package lu.tudor.santec.gecamed.office.gui.sitemanagement;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;
import lu.tudor.santec.i18n.Translatrix;

public class SiteEditDialog extends GECAMedBaseDialog {

    private static final long serialVersionUID = 1L;
    private SitePanel sitePanel;
    private Site site;
    private MainFrame mainFrame;
    private boolean retVal = false;

    public SiteEditDialog() {
	super(MainFrame.getInstance(), Translatrix.getTranslationString("office.sitemanagement"), true);
	this.mainFrame = MainFrame.getInstance();
	this.sitePanel = new SitePanel();
	this.addMainPanel(sitePanel);
	
	this.pack();
	
	this.okButton.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		retVal = true;
	    }
	});
    }
    
    public void editSite(Site site) {
	this.retVal = false;
	this.site = site;
	this.sitePanel.setSite(site);
	this.setLocationRelativeTo(mainFrame);
	this.setVisible(true);
    }

    public Site getSite() {
	if (retVal == false)
	    return null;
	sitePanel.getSite(site);	
	return site;
    }
    

}
