package lu.tudor.santec.gecamed.office.gui.physicianmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

import javax.ejb.FinderException;

import lu.tudor.santec.gecamed.core.gui.GECAMedMessage;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessageListener;
import lu.tudor.santec.gecamed.core.gui.listener.MessageListenerRegister;
import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.FilterTableModel;
import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.UserAdminBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserAdminInterface;
import lu.tudor.santec.i18n.Translatrix;

public class PhysicianTableModel extends FilterTableModel {

	private static final String[] columnName = { 
		Translatrix.getTranslationString("ID"), 
		Translatrix.getTranslationString("phy.titel"), 
		Translatrix.getTranslationString("phy.firstName"), 
		Translatrix.getTranslationString("phy.lastName"), 
		Translatrix.getTranslationString("phy.ucm"),
		Translatrix.getTranslationString("user"),
		Translatrix.getTranslationString("phy.speciality"), 
		""
	};

	private static final Class<?>[] columnsClasses = {
		Integer.class, 
		String.class, 
		String.class, 
		String.class, 
		String.class, 
		String.class,
		String.class, 
		String.class 
	};

	private static final long serialVersionUID = 1L;
	private Vector<Physician> data;

	private TextFilter textFilter;
	
	protected HashMap<Integer, String> userHash = new HashMap<Integer, String>();

	private UserAdminInterface usermanager;

	
	public PhysicianTableModel() {
		this.usermanager = (UserAdminInterface) ManagerFactory.getRemote(UserAdminBean.class);
		reloadUsers();
		
		MessageListenerRegister.addGECAMedMessageListener(new GECAMedMessageListener() {
			public void handleGECAMedMessage(GECAMedMessage message) {
				if (message.getMessage().equals(MessageListenerRegister.MESSAGE_USER_CHANGED)) {
					reloadUsers();
				}
			}
		});
	}
	
	private void reloadUsers() {
		// reload users
		try {
			ArrayList<GecamedUser> userlist = new ArrayList<GecamedUser>(usermanager.getUserList());
			userHash.clear();
			for (GecamedUser gecamedUser : userlist) {
				userHash.put(gecamedUser.getId(), gecamedUser.getLogin());
			}
		} catch (FinderException e) {
			e.printStackTrace();
		}
	}

	public void setData(Collection<Physician> data) {
		if (data != null) {
			this.data = new Vector<Physician>(data);
		} else {
			this.data = null;
		}
		setTableData(this.data);
		this.fireTableDataChanged();
	}

	public Vector<Physician> getData() {
		return data;
	}

	public String getColumnName(int column) {
		return columnName[column];
	}

	public int getRowCount() {
		if (isFiltering()) {
			return getFilteredRowCount();
		}
		try {
			return data.size();
		} catch (Exception e) {
			return 0;
		}
	}

	public int getColumnCount() {
		return columnsClasses.length;
	}

	public Class<?> getColumnClass(int column) {
		return columnsClasses[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		if (isFiltering()) {
			rowIndex = filteredToModel(rowIndex);
		}
		
		if (rowIndex > data.size()) return null;
		
		Physician phy = data.get(rowIndex);
		try {
			switch (columnIndex) {
			case 0:
				return phy.getId();
			case 1:
				return phy.getTitle();
			case 2:
				return phy.getFirstName();
			case 3:
				return phy.getName();
			case 4:
				return phy.getUcmCode();
			case 5:
				try {
					return userHash.get(phy.getUserId());					
				} catch (Exception e) {
					return "";
				}
			case 6:
				return phy.getSpeciality();
			case 7:
				return phy.getFirstName() + " " + phy.getName() + " " + phy.getUcmCode();
			default:
				return "";
			}
		} catch (Exception e) {
			return "";
		}
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	public Physician getPhysician(int row) {
		if (isFiltering()) {
			row = filteredToModel(row);
		}
		try {
			return data.get(row);
		} catch (Exception e) {
			return null;
		}

	}

	public TableFilter getTextFilter() {
		if (textFilter == null) {
			this.textFilter = new TextFilter();
			installFilter(textFilter, 7);
		}
		return textFilter;
	}

	
	
	/**
	 * @version
	 * <br>$Log: PhysicianTableModel.java,v $
	 */
	public class TextFilter implements TableFilter {

		private String searchText = "";

		public boolean accept(Object p_Value) {
			if (p_Value instanceof String) {
				String text = (String) p_Value;
				if (text.toLowerCase().contains(searchText))
					return true;
			}
			return false;
		}

		public void compile() {
		}

		public boolean isFiltering() {
			return true;
		}

		public void setFilter(Object p_FilterValue) {
			if (p_FilterValue instanceof String)
				this.searchText = ((String) p_FilterValue).toLowerCase();
		}

	}

}