/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.gui.physicianmanagement;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

/**
 * CellRenderer to render the users in a different color if they have unsaved changes.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: UserCellRenderer.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-15 10:18:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class PhysicianCellRenderer extends LineColorCellRenderer {

	private static final long serialVersionUID = 1L;
	private PhysicianTableModel model;

	public PhysicianCellRenderer(PhysicianTableModel model) {
		this.model = model;
	}
	
	@Override
	public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {
		Component c= super.getTableCellRendererComponent(p_Table, value, p_IsSelected, hasFocus, p_Row, p_Column);
		Color l_Background;
		
		
		l_Background = (p_Row % 2 == 0) ? c_OddColor : c_EvenColor;
		if (p_IsSelected)
			this.setBackground(p_Table.getSelectionBackground());
		else
			this.setBackground(l_Background);

		
		if (p_Column == 0) {
			try {
				Physician p = model.getPhysician(p_Row);
				if (p != null && p.getColor() != null) 
					this.setBackground(new Color(p.getColor()));				
			} catch (Exception e) {}
		}

		if(p_Table.getColumnCount() >= p_Column) {
			setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(),
				getPreferredSize().height);
		}

		if (p_Table.getRowHeight(p_Row) < getPreferredSize().height) {
			p_Table.setRowHeight(p_Row, getPreferredSize().height);
		}
				
		return c;
	}
}
