/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.gui.officemanagement;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.naming.InitialContext;
import javax.swing.JButton;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.billing.gui.admin.AccountPanel;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.StatusBar;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Office;
import lu.tudor.santec.gecamed.office.ejb.session.beans.OfficeManagerBean;
import lu.tudor.santec.gecamed.office.ejb.session.interfaces.OfficeManagerInterface;
import lu.tudor.santec.gecamed.office.gui.sitemanagement.SiteManagementPanel;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * JPanel to edit the Office Data
 * parent panel for office addresses, phones and general data
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: OfficeManagementPanel.java,v $
 * <br>Revision 1.22  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.21  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.20  2012-11-30 08:00:59  ferring
 * <br>postal code added to country and to formatter
 * <br>Short patient title corrected and long patient title added
 * <br>
 * <br>Revision 1.19  2010-03-12 14:17:42  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.18  2009-02-11 14:14:34  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 * <br>Revision 1.17  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 * <br>Revision 1.16  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.15  2008-01-15 13:08:50  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class OfficeManagementPanel extends GECAMedTab implements ActionListener {

	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(OfficeManagementPanel.class
			.getName());
	
	private static final long serialVersionUID = 1L;
	
	private JButton saveButton;
	private OfficeGeneralPanel officeGeneralPanel;
	private OfficeAddressPanel officeAddressPanel;
	private boolean unsavedChanges = false;
	public Office currentOffice;
	private OfficeManagerInterface manager;

	private boolean notBuild = true;

	private AccountPanel accountPanel;

	private SiteManagementPanel siteManagementPanel;


	public OfficeManagementPanel() {
		this.setOpaque(false);
		Translatrix.addBundle("lu.tudor.santec.gecamed.office.gui.resources.WidgetResources");
		this.setTitle(Translatrix.getTranslationString("office.office"));
		this.setIcon(GECAMedModule.getIcon(GECAMedIconNames.OFFICE));
		if (notBuild) {
			buildPanel();
			getOffice();
			notBuild = false;
		}
	}
	
	/**
     * adds the components to the panel
     */
    private void buildPanel()
    {

    	// initialize Components
        initComponents();
        FormLayout layout = new FormLayout("3dlu, fill:pref:grow, 3dlu, pref", "pref, 3dlu, pref, 3dlu, 60dlu, 3dlu, top:140dlu:grow");
        CellConstraints cc = new CellConstraints();
		this.setLayout(layout);

		officeGeneralPanel = new OfficeGeneralPanel(this);
		this.add(officeGeneralPanel, cc.xy(2,1));
		officeAddressPanel = new OfficeAddressPanel(this);
		this.add(officeAddressPanel, cc.xy(2,3));
		
		accountPanel = new AccountPanel();
		accountPanel.setHolder(null);
		this.add(accountPanel, cc.xy(2,5));
		
		siteManagementPanel = new SiteManagementPanel(this);
		this.add(siteManagementPanel, cc.xy(2,7));
		
	        JPanel bb = new JPanel(new FormLayout("pref, 4dlu", "pref,1dlu,pref:grow"));
	        bb.setOpaque(false);
	        bb.add(this.saveButton, cc.xy(1, 1));

		this.add(bb, cc.xywh(4,1,1,3));
		
    }

    /**
     * initialises the Components
     */
    private void initComponents()
    {
    	 // Get the type manager
        InitialContext ctx;
		try {
			ctx = new InitialContext();
			this.manager = (OfficeManagerInterface) ManagerFactory.getRemote(OfficeManagerBean.class);
			ctx.close();
	    } catch (Exception e) {
	    	logger.log(Level.WARN, "retrieving OfficeManagerBean failed" ,e);
		}
	 
		this.saveButton = ButtonFactory.createNarrowButton(GECAMedModule.getIcon(GECAMedIconNames.SAVE));
		this.saveButton.setToolTipText(Translatrix.getTranslationString("core.save")); 
		this.saveButton.addActionListener(this);
		this.saveButton.setEnabled(false);

    }
	
      
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.saveButton)) {
			this.saveOffice();
		}
	}
	
	
    /**
	 * update all shown values
	 */
    public void getOffice() {
    	
    	try {
			this.currentOffice = manager.getOffice(1);
		} catch (Exception e) {
			StatusBar.getInstance().setWarningText(Translatrix.getTranslationString("office.noOffice"));
		}
		if (this.currentOffice == null) {
			this.currentOffice = new Office();
		}
    	
    	this.officeGeneralPanel.setOffice(this.currentOffice);
//    	this.officePhonePanel.setOffice(this.currentOffice);
    	this.officeAddressPanel.setOffice(this.currentOffice);
        this.setUnsavedChanges(false);
    }
    
    
    /**
     * collect the values from the Panel and save them to db
     */
    public void saveOffice() {
        // collect values from panels
        this.officeGeneralPanel.getData(currentOffice);
//        this.officePhonePanel.getData(currentOffice);
        this.officeAddressPanel.getData(currentOffice);

        // save Patient
            try {
			this.currentOffice = manager.saveOffice(currentOffice);
			 logger.info("office: " + currentOffice.getName() + " saved");
			StatusBar.getInstance().setProgress(
					Translatrix.getTranslationString("office.officeSaved"), 100);
			this.setUnsavedChanges(false);
		} catch (Exception e1) {
			MainFrame.reportServerError(e1);
		}
    }
    
	/**
	 * @param unsavedChanges
	 */
	public void setUnsavedChanges(boolean unsavedChanges) {
		super.setModified(unsavedChanges);
		if (this.unsavedChanges == unsavedChanges) {
			return;
		}
		if (unsavedChanges == true) {
			this.saveButton.setEnabled(true);
//			this.patientPanel.setTabTitle(this.patientPanel.getTabTitle() + " *");
		} else {
			this.saveButton.setEnabled(false);
//			String title = this.patientPanel.getTabTitle();
//			this.patientPanel.setTabTitle(title.substring(0, title.length()-2));
		}
		this.unsavedChanges = unsavedChanges;
	}
    

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#preparetoShowup()
	 */
	@Override
	public void preparetoShowup() {
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#preparetoHide()
	 */
	@Override
	public void preparetoHide() {
		if (this.unsavedChanges) {
			saveOffice();
		}
	}

	/**
	 * enables the Panel and all Subpanels
	 * @param b
	 */
	public void enablePanel(boolean b) {
		this.saveButton.setEnabled(b);
		this.officeGeneralPanel.setEnabled(b);
//		this.officePhonePanel.setEnabled(b);
		this.officeAddressPanel.setEnabled(b);
		this.accountPanel.setEditable(b);
		this.siteManagementPanel.enablePanel(b);
	}
	
	
	
}
