/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.session.interfaces;

import java.util.Collection;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;

import lu.tudor.santec.gecamed.office.ejb.entity.beans.Office;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;


/**
 * Session Bean Interface that manages the access to the office and physician EJBs.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: OfficeManagerInterface.java,v $
 * <br>Revision 1.9  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 * <br>Revision 1.8  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * <br>Revision 1.7  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-07-14 14:33:25  hermen
 * <br>first checkin of the xml2physician mapper
 * <br>
 * <br>Revision 1.5  2008-01-15 13:08:51  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@Remote
public interface OfficeManagerInterface {

//	/**
//	 * Returns a list of all available physicians
//	 * 
//	 * @return
//	 */
//	public List<Physician> getAllPhysicians();
	
	/**
	 * saves the spezified Physician
	 *
	 * @param office Physician Object
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract Physician savePhysician(Physician physician) throws Exception;
	
	/**
	 * deletes the spezified Physician
	 *
	 * @param office Physician Object
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract void deletePhysician(Integer physicianID) throws Exception;

	/**
	 * Returns the spezified Physician
	 *
	 * @return a Physician Object 
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract Physician getPhysician(Integer physicianID) throws Exception;

	
	
	/**
	 * saves the spezified Office
	 *
	 * @param office Office Object
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract Office saveOffice(Office office) throws Exception;

	/**
	 * Returns the spezified Office
	 *
	 * @return a Office Object 
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract Office getOffice(Integer officetID) throws Exception;
	
	/**
	 * Returns the physician by its ucm code
	 *
	 * @return a physician Object 
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public Physician getPhysicianByUCM(String ucm) throws Exception;
	
	public Collection<Site> getSites() throws Exception;

	@RolesAllowed("gecam")
	public Site saveSite(Site site) throws Exception;
	
	@RolesAllowed("gecam")
	public void deleteSite(Integer siteID) throws Exception;
	
}
