/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;

/**
 * Entity Bean that maps the <b>office.site_address</b> table
 * which stores the addresses of the sites
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 *@Version
 * <br>$Log: SiteAddress.java,v $
 * <br>Revision 1.1  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * 
 */
@Entity
@Table(name = "site_address", schema = "office")
public class SiteAddress extends GECAMedAddressBean implements Serializable {

    private static final long serialVersionUID = 1L;

    
}
