/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.AgendaCalendar;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;

/**
 * Entity Bean that maps the <b>office.site</b> table
 * which stores a informations such as address, name, phones of the site
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 *@Version
 * <br>$Log: Site.java,v $
 * <br>Revision 1.2  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 * <br>Revision 1.1  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * 
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllSite",
        query="SELECT OBJECT(o) FROM Site o ORDER BY o.id")
})

@Entity
@Table(name = "site", schema = "office")
public class Site extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	public static final String UCM_DEFAULT = "000000-00";
	
	private Integer office_id;
	private String name;
	private String website;
	private String email;
	private String phone;
	private String fax;
	private String information;
	private String ucmCode;
	private SiteAddress siteAddress;
	
	public Site() {
		this.ucmCode = UCM_DEFAULT;
	}
	
	/**
	 * @return Returns the email.
	 */
	@javax.persistence.Column(name = "email")
	public String getEmail() {
		return email;
	}
	
	/**
	 * @param email The email to set.
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	
	/**
	 * @return the phone
	 */
	@javax.persistence.Column(name = "phone")
	public String getPhone() {
	    return phone;
	}

	/**
	 * @param phone the phone to set
	 */
	public void setPhone(String phone) {
	    this.phone = phone;
	}

	/**
	 * @return the fax
	 */
	@javax.persistence.Column(name = "fax")
	public String getFax() {
	    return fax;
	}

	/**
	 * @param fax the fax to set
	 */
	public void setFax(String fax) {
	    this.fax = fax;
	}
	
	/**
	 * @return Returns the name.
	 */
	@javax.persistence.Column(name = "name")
	public String getName() {
		return name;
	}
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the website.
	 */
	@javax.persistence.Column(name = "website")
	public String getWebsite() {
		return website;
	}
	
	/**
	 * @param website The website to set.
	 */
	public void setWebsite(String website) {
		this.website = website;
	}

	/**
	 * returns the site address
	 * @return the site address
	 */
	@OneToOne(cascade = {CascadeType.ALL})
	@JoinColumn(name = "address_id")
	public SiteAddress getSiteAddress() {
		return this.siteAddress;
	}

	/**
	 * sets the site address
	 * 
	 * @param site Address
	 */
	public void setSiteAddress(SiteAddress siteAddress) {
		this.siteAddress = siteAddress;
	}
		
	/**
	 * @return Returns the ucmCode.
	 */
	@javax.persistence.Column(name = "ucm_code")
	public String getUcmCode() {
		return ucmCode;
	}
	/**
	 * @param ucmCode The ucmCode to set.
	 */
	public void setUcmCode(String ucmCode) {
		this.ucmCode = ucmCode;
	}
	

	/**
	 * @return Returns the information.
	 */
	@javax.persistence.Column(name = "information")
	public String getInformation() {
		return information;
	}

	/**
	 * @param information The information to set.
	 */
	public void setInformation(String information) {
		this.information = information;
	}

	/**
	 * @return the office_id
	 */
	public Integer getOffice_id() {
	    return office_id;
	}

	/**
	 * @param office_id the office_id to set
	 */
	public void setOffice_id(Integer office_id) {
	    this.office_id = office_id;
	}
	
	public String toString() {
	    StringBuffer sb = new StringBuffer(getName());
	    if (this.siteAddress != null && this.siteAddress.getLocality() != null) {
		sb.append(" (").append(this.siteAddress.getLocality()).append(")"); 
	    }
	    return sb.toString();
	}
	
	@Override
	public int compareTo (GECAMedEntityBean o)
	{
		if (o != null && o instanceof Site)
		{
			int i = GECAMedUtils.compareTo(this.getName(), ((Site)o).getName());
			if (i != 0)
				return i;
		}
		return super.compareTo(o);
	}
}
