/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.entity.beans;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;

/**
 * Entity Bean that maps the <b>office.physician_address</b> table
 * which stores the addresses of the physician
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 *@Version
 * <br>$Log: PhysicianAddress.java,v $
 * <br>Revision 1.5  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * <br>Revision 1.4  2008-12-18 13:06:58  mack
 * <br>Localities are to be printed in uppercase characters
 * <br>
 * <br>Revision 1.3  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-05-09 13:40:45  hermen
 * <br>added physician address
 * <br>
 * <br>Revision 1.5  2008-01-15 13:08:51  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * 
 */
@Entity
@Table(name = "physician_address", schema = "office")
public class PhysicianAddress extends GECAMedAddressBean {

	private static final long serialVersionUID = 1L;
	
}
