/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.templatelist;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.controller.ControllerConfig;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.i18n.Translatrix;

/*
 * Renderer for a list that represents templates
 */

public class ListRenderer extends LineColorListRenderer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Icon icon;

	// Creates the look for an entry in the template list
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {

		LetterTemplate template = (LetterTemplate) value;

		String description = template.getDescription();

//		boolean newline = false;
//
//		// cut the description if to long
//		final int max_line_length = 70;
//
		if (description != null && !"".equals(description.trim())) 
		{
//			if (description.length() > max_line_length) {
//				if (newline) {
//					description = description.substring(0, max_line_length)
//							+ "<br>"
//							+ description.substring(max_line_length,
//									description.length());
//				} else {
//					description = description.substring(0, max_line_length)
//							+ "...";
//				}
//			}
			description = description
//					.replace("<", "&lt;")
					.replace("\n", "<br>");
		} 
		else 
//		if (description == null || "".equals(description.trim()))
		{
			description = Translatrix.getTranslationString("LetterTemplateModule.details.nodescription");
		}

		String text = "<html><font size=\"4.5\">"
				+ template.getName()
				+ "</font><br>"
				+ "<p><font size=\"2\">"
				+ description
				+ " <br> "
				+ Translatrix.getTranslationString("LetterTemplateModule.details.type_nohtml")
				+ " "
				+  template.getType() + " </font> </p></html>";

		// Icon for the template, corresponding to the type
		try {
			icon = IconFetcher.getMediumIcon(LetterTemplateModule.class,
					ControllerConfig.iconMapping.get(template.getMimetype()+(template.getPlaceholderVersion() < 1 ? "old" : "")));
		} catch (Exception e) {}

		JLabel label = (JLabel) super.getListCellRendererComponent(list, text,
				index, isSelected, cellHasFocus);
		label.setIcon(icon);

		return label;
	}
}
