///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.letter.gui.letterlist;
//
//import java.awt.Component;
//import java.text.SimpleDateFormat;
//import java.util.ArrayList;
//
//import javax.swing.JLabel;
//import javax.swing.JTable;
//
//import lu.tudor.santec.gecamed.core.gui.IconFetcher;
//import lu.tudor.santec.gecamed.core.gui.MainFrame;
//import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.core.utils.controller.ControllerConfig;
//import lu.tudor.santec.gecamed.letter.ejb.entity.beans.Letter;
//import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterBean;
//import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterInterface;
//import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
//import lu.tudor.santec.i18n.Translatrix;
//
///*
// *  Table Render for the table that shows the letters of a patient
// */
//
//public class TableRenderer extends LineColorCellRenderer {
//
//	/**
//	 * 
//	 */
//	private static final long serialVersionUID = 1L;
//
//	private SimpleDateFormat formatter;
//
//	private LetterInterface letterManager;
//
//	private TableModel tableModel;
//
//	private Letter letter;
//
//	private ArrayList<Letter> letters;
//
//	public TableRenderer(TableModel tableModel) {
//		this.tableModel = tableModel;
//		String pattern = "EEE d MMM y";
//		formatter = new SimpleDateFormat(pattern);
//		letterManager = (LetterInterface) ManagerFactory
//				.getRemote(LetterBean.class);
//		letter = new Letter();
//		letters = new ArrayList<Letter>();
//	}
//
//	@Override
//	public Component getTableCellRendererComponent(JTable p_Table,
//			Object value, boolean p_IsSelected, boolean hasFocus, int p_Row,
//			int p_Column) {
//
//		JLabel l = (JLabel) super.getTableCellRendererComponent(p_Table, value,
//				p_IsSelected, hasFocus, p_Row, p_Column);
//		switch (p_Column) {
//		case 0:
//			try {
//				letters = (ArrayList<Letter>) letterManager
//						.getLetterByIncidentEntry(tableModel.getData().get(
//								p_Row).getEntry().getId());
//				letter = letters.get(0);
//
//				l.setIcon(IconFetcher.getMediumIcon(
//								LetterTemplateModule.class,
//								ControllerConfig.iconMapping.get(letter
//										.getMimetype())));
//			} catch (Exception e) {
//				e.printStackTrace();
//			}
//			break;
//		case 1:
//			try {
//				l.setText(letter.getType());
//			} catch (Exception e) {
//				l.setText("");
//			}
//			l.setIcon(null);
//			break;
//		case 2:
//			try {
//				if (letter.getMimetype().equals(ControllerConfig.MIME_WORD))
//					l.setText("Word");
//				if (letter.getMimetype().equalsIgnoreCase(
//						ControllerConfig.MIME_WRITER))
//					l.setText("Writer");
//			} catch (Exception e) {
//				l.setText("");
//			}
//			l.setIcon(null);
//			break;
//		case 3:
//			if (value != null) {
//				if (value.equals("") || value.equals(" ")) {
//					l
//							.setText(Translatrix
//									.getTranslationString("LetterTemplateModule.details.nodescription"));
//				}
//			}
//			l.setIcon(null);
//			break;
//		case 4:
//			if (value != null) {
//				l.setText(formatter.format(value));
//			}
//			l.setIcon(null);
//			break;
//		case 5:
//			if (value != null) {
//				l.setText(MainFrame.getPhysicianById((Integer) value) + "");
//			}
//			l.setIcon(null);
//			break;
//		case 6:
//			if (value != null) {
//				l.setText(formatter.format(value));
//			}
//			l.setIcon(null);
//			break;
//		case 7:
//			if (value != null) {
//				l.setText(MainFrame.getPhysicianById((Integer) value) + "");
//			}
//			l.setIcon(null);
//			break;
//		default:
//			l.setIcon(null);
//		}
//		return l;
//	}
//}
