/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.letterlist;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.letter.gui.components.LimitedTextArea;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;




/**
 * @author martin.heinemann@tudor.lu
 * 01.07.2008
 * 11:40:01
 *
 *
 * @version
 * <br>$Log: DescriptionDialog.java,v $
 * <br>Revision 1.3  2013-02-05 13:10:42  ferring
 * <br>translation translated
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class DescriptionDialog extends JDialog implements ActionListener {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private LimitedTextArea tDescription;

	private boolean changed = false;

	public DescriptionDialog(String desc) {
		setLayout(new FormLayout("fill:pref:grow", "fill:pref:grow,15dlu"));
		tDescription = new LimitedTextArea(300);
		tDescription.setText(desc);
		tDescription.setLineWrap(true);
		this.add(tDescription, new CellConstraints().xy(1, 1));
		JButton bSave = new JButton("Save");
		bSave.addActionListener(this);
		setTitle(Translatrix.getTranslationString("LetterTemplateModule.menu.changedescription"));
		setLocationRelativeTo(MainFrame.getInstance());
		this.add(bSave, new CellConstraints().xy(1, 2));
		this.setSize(300, 200);
		setModal(true);
		this.setVisible(true);
	}

	public boolean hasChanged() {
		return changed;
	}

	public void actionPerformed(ActionEvent e) {
		changed = true;
		this.setVisible(false);
	}

	public LimitedTextArea getTDescription() {
		return tDescription;
	}

	public void setTDescription(LimitedTextArea description) {
		tDescription = description;
	}
}
