package lu.tudor.santec.gecamed.letter.gui.dialogs;

import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterPlaceholder;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: PlaceholderCellRenderer.java,v $
 * <br>Revision 1.1  2012-11-26 07:56:14  ferring
 * <br>New placeholders are introduced to the letter module
 * <br>The replacement algorithm in Word- and WriterCotnroller has been changed
 * <br>Multicontacts are prepared, but not yet implemented
 * <br>
 */

public class PlaceholderCellRenderer extends JLabel implements ListCellRenderer
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public PlaceholderCellRenderer()
	{
		setOpaque(true);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
	{
		LetterPlaceholder 	p;
		
		
		if (value instanceof LetterPlaceholder)
		{
			p	= (LetterPlaceholder) value;
			setText(p.getName());
			setToolTipText(p.getComment());
		}
		else
		{
			setText(String.valueOf(value));
			setToolTipText(null);
		}
		
		if (isSelected)
			setBackground(list.getSelectionBackground());
		else if (index % 2 == 0)
			setBackground(GECAMedColors.c_EvenLineBackground);
		else 
			setBackground(GECAMedColors.c_OddLineBackground);
		
		if (cellHasFocus)
			setBorder(BorderFactory.createLineBorder(index % 2 == 0 
					? GECAMedColors.c_EvenLineBackground 
					: GECAMedColors.c_OddLineBackground));
		else
			setBorder(BorderFactory.createEmptyBorder());
		
		return this;
	}
}
