/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 *  DeleteTemplateAction deletes the template that is selechted in the list
 */

public class DeleteTemplateAction extends GECAMedAction {

    	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger
		.getLogger(DeleteTemplateAction.class.getName());
    
	public DeleteTemplateAction(GECAMedModule p_Parent, String p_Name,
			ImageIcon p_Icon, Integer p_Shortcut, boolean p_IsMenuAction,
			boolean p_IsTopBarAction, boolean p_IsBottomBarAction) {

		super(p_Parent, p_Name, p_Icon, p_Shortcut, p_IsMenuAction,
				p_IsTopBarAction, p_IsBottomBarAction);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public void actionPerformed(ActionEvent e) 
	{
		LetterTemplateModule module	= LetterTemplateModule.getInstance();
		try 
		{
			// Get the index of the selected template in the list
			int index = module.getList().getSelectedIndex();

			if (index >= 0) 
			{
				if (JOptionPane.showConfirmDialog(
						module.getContentPane(), 
						Translatrix.getTranslationString("LetterTemplateModule.dialog.confirm.delete"))
						== JOptionPane.YES_OPTION) 
				{
					// Get the template itself
					LetterTemplate letterTemplate = (LetterTemplate) module.getList().getSelectedValue();

					// Delete the template and notify about it's success
					if (module.getManager().removeTemplate(letterTemplate)) {
						module.updateList(index - 1);
						module.getCbModel().queryTemplateTypes();
					} else {
						JOptionPane.showMessageDialog(
								module.getContentPane(),
								Translatrix.getTranslationString("LetterTemplateModule.dialog.error.notdeleted"),
								Translatrix.getTranslationString("LetterTemplateModule.dialog.error.title"),
								JOptionPane.ERROR_MESSAGE);
					}
				}
			} else {
				JOptionPane.showMessageDialog(
						module.getContentPane(),
						Translatrix.getTranslationString("LetterTemplateModule.dialog.error.noindex"),
						Translatrix.getTranslationString("LetterTemplateModule.dialog.error.title"),
						JOptionPane.ERROR_MESSAGE);
			}
		} catch (Exception exception) {
		        logger.log(Level.WARN, "Error deleting template: ", exception);
			JOptionPane.showMessageDialog(
					module.getContentPane(),
					Translatrix.getTranslationString("LetterTemplateModule.dialog.error.noindex"),
					Translatrix.getTranslationString("LetterTemplateModule.dialog.error.title"),
					JOptionPane.ERROR_MESSAGE);
		}
		module.refresh();
	}
}
