package lu.tudor.santec.gecamed.letter.gui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.controller.document.DocumentController;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;
import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterTemplateBean;
import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterTemplateInterface;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CopyTemplateAction.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:24  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2013-10-31 10:29:31  troth
 * <br>Fix NullPointerException, if no template is open, we can't make a copy.
 * <br>
 * <br>Revision 1.2  2013-07-15 06:18:35  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.1  2013-01-03 12:43:10  ferring
 * <br>Copy letter template function added
 * <br>
 */

public class CopyTemplateAction extends GECAMedAction
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(CopyTemplateAction.class.getName());
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public CopyTemplateAction (GECAMedModule parent, String name,
			ImageIcon icon, Integer shortcut, boolean isMenuAction,
			boolean isTopBarAction, boolean isBottomBarAction) 
	{
		super(parent, name, icon, shortcut, isMenuAction,
				isTopBarAction, isBottomBarAction);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	@Override
	public void actionPerformed(ActionEvent event)
	{
		LetterTemplateModule	module		= LetterTemplateModule.getInstance();
		LetterTemplate			orgTemplate	= (LetterTemplate) module.getList().getSelectedValue();
		LetterTemplateInterface	manager		= (LetterTemplateInterface) ManagerFactory.getRemote(LetterTemplateBean.class);
		LetterTemplate			copiedTemplate;
		String					copiedTemplateName;
		String					copiedFileName;
		String					fileExtension;
		File					tmpFile;
		byte[]					data;
		
		
		// ask for a unique name
//		do
//		{
//			if (newName != null)
//				GECAMedBaseDialogImpl.showMessageDialog(module, 
//						Translatrix.getTranslationString("LetterTemplateModule.dialog.copy.nameAlreadyExistsTitle"), 
//						Translatrix.getTranslationString("LetterTemplateModule.dialog.copy.nameAlreadyExistsMessage"), 
//						GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
//						GECAMedModule.getMediumIcon(GECAMedIconNames.ERROR));
//			else
//				newName = Translatrix.getTranslationString("") + orgTemplate.getName();
//			
//			newName	= GECAMedBaseDialogImpl.showInputMessageDialog(module, 
//					Translatrix.getTranslationString("LetterTemplateModule.dialog.copy.nameCopyTitle"), 
//					Translatrix.getTranslationString("LetterTemplateModule.dialog.copy.nameCopyMessage", 
//							new String[] { orgTemplate.getName() }), 
//					newName);
//			
//			if (newName == null)
//				return;
//		}
//		while (newName.equals(orgTemplate.getName()) 
//				|| manager.doesTemplateNameAlreadyExist(newName));
		
		
		if (orgTemplate == null)
			return;
		
		copiedTemplateName	= Translatrix.getTranslationString("LetterTemplateModule.dialog.copy.copyOf") + orgTemplate.getName();
		
		
		// copy the data
		try
		{
			data			= manager.getTemplateBinary(orgTemplate);
			copiedFileName	= orgTemplate.getGeneratedFileName();
			fileExtension	= copiedFileName.substring(copiedFileName.lastIndexOf('.'));
			tmpFile			= File.createTempFile(DocumentController.DOCUMENT_NAME, fileExtension);
			copiedFileName	= tmpFile.getName();
			copiedFileName	= manager.setTemplateBinary(copiedFileName, data);
			copiedTemplate	= (LetterTemplate) orgTemplate.clone();
			copiedTemplate.setId(null);
			copiedTemplate.setName(copiedTemplateName);
			copiedTemplate.setCreatedOn(new Date());
			copiedTemplate.setModifiedOn(new Date());
			copiedTemplate.setModifiedBy(GECAMedModule.getCurrentPhysician().getId());
			copiedTemplate.setGeneratedFileName(copiedFileName);
			copiedTemplate	= manager.addTemplate(copiedTemplate);
			module.refresh();
			module.getList().setSelectedValue(copiedTemplate, true);
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		try {
			LetterTemplateModule.getInstance().refresh();			
		} catch (Exception e) {}
	}
}
