/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
//import lu.tudor.santec.gecamed.letter.gui.dialogs.AddTemplateDialog;
import lu.tudor.santec.gecamed.letter.gui.dialogs.NewTemplateDialog;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


/*
 * AddTemplateAction opens a new AddTemplateDialog on its execution
 */

public class AddTemplateAction extends GECAMedAction {

    	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(AddTemplateAction.class
		.getName());
    
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public AddTemplateAction(GECAMedModule p_Parent, String p_Name,
			ImageIcon p_Icon, Integer p_Shortcut, boolean p_IsMenuAction,
			boolean p_IsTopBarAction, boolean p_IsBottomBarAction) {

		super(p_Parent, p_Name, p_Icon, p_Shortcut, p_IsMenuAction,
				p_IsTopBarAction, p_IsBottomBarAction);
	}

	public void actionPerformed(ActionEvent p_Event) {
		try {
//			new AddTemplateDialog(LetterTemplateModule.getInstance()
//					.getContentPane());
			NewTemplateDialog td = new NewTemplateDialog();
			MainFrame.showDialogCentered(td);
		} catch (Exception e) {
		    logger.log(Level.WARN, "Error adding template: ", e);
			e.printStackTrace();
			JOptionPane.showMessageDialog(LetterTemplateModule.getInstance().getContentPane(), 
					Translatrix.getTranslationString("LetterTemplateModule.dialog.error.templatecreating"), 
					Translatrix.getTranslationString("LetterTemplateModule.dialog.error.title"), 
					JOptionPane.ERROR_MESSAGE);
		}
		try {
			LetterTemplateModule.getInstance().refresh();			
		} catch (Exception e) {}
	}
}
