///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.letter.gui;
//
//import java.awt.Color;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseListener;
//import java.beans.PropertyChangeEvent;
//import java.beans.PropertyChangeListener;
//import java.util.ArrayList;
//import java.util.List;
//
//import javax.swing.JButton;
//import javax.swing.JComboBox;
//import javax.swing.JLabel;
//import javax.swing.JPanel;
//import javax.swing.JPopupMenu;
//import javax.swing.JScrollPane;
//import javax.swing.JTable;
//import javax.swing.JTextField;
//import javax.swing.event.CaretEvent;
//import javax.swing.event.CaretListener;
//
//import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
//import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
//import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
//import lu.tudor.santec.gecamed.core.gui.IconFetcher;
//import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.letter.ejb.entity.beans.Letter;
//import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterBean;
//import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterInterface;
//import lu.tudor.santec.gecamed.letter.gui.components.ComboBoxSearchTypeModel;
//import lu.tudor.santec.gecamed.letter.gui.components.ComboBoxTypeModel;
//import lu.tudor.santec.gecamed.letter.gui.letterlist.TableModel;
//import lu.tudor.santec.gecamed.letter.gui.letterlist.TableRenderer;
//import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
//import lu.tudor.santec.gecamed.patient.gui.PatientPanel;
//import lu.tudor.santec.gecamed.patient.gui.PatientViewTab;
//import lu.tudor.santec.gecamed.patient.gui.history.table.HistoryTableModel;
//import lu.tudor.santec.gecamed.patient.gui.history.table.HistRow;
//import lu.tudor.santec.i18n.Translatrix;
//
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//import com.toedter.calendar.JDateChooser;
//
///*
// * 
// *  MAIN PART THAT MANAGES LETTERS
// * 
// */
//
//public class LetterPanel extends PatientViewTab {
//
//	/**
//	 * 
//	 */
//	private static final long serialVersionUID = 1L;
//
//	public static final String NAME = "LETTER_PANEL";
//
//	private static final Color BLUE_FRONT = new Color(163, 186, 208);
//
//	private HeaderedPanel tablePanel;
//
//	private HeaderedPanel filterPanel;
//
//	private PatientPanel patientPanel;
//
//	private JTable table;
//
//	private TableModel tableModel;
//
//	private List<HistRow> tableData;
//
//	private List<HistRow> typeData;
//
//	private List<HistRow> beginDateData;
//
//	private JComboBox cbType;
//
//	private LetterInterface letterManager;
//
//	private ComboBoxSearchTypeModel cbSearchModel;
//
//	private ComboBoxTypeModel cbModel;
//
//	private JTextField tFilterName;
//
//	private JDateChooser dBegin;
//
//	private JDateChooser dEnd;
//
//	private List<HistRow> endDateData;
//
//	private JPopupMenu menu;
//
//	private static LetterPanel letterPanel;
//
//	public LetterPanel(PatientPanel panel) {
//
//		// Saving this instance
//		letterPanel = this;
//
//		// Reference to the PatientPanel, to get the history table model
//		patientPanel = panel;
//
//		// Getting the manager for letters in order to query the types of
//		// letters
//		letterManager = (LetterInterface) ManagerFactory
//				.getRemote(LetterBean.class);
//
//		// Setting the Icon of the PatientViewTab
//		this.setIcon(IconFetcher.getMediumIcon(LetterTemplateModule.class,
//				LetterTemplateModule.ICON_LETTER));
//
//		// Content
//		JPanel content = new JPanel(new FormLayout("fill:100:grow",
//				"80dlu,fill:100:grow"));
//		content.setOpaque(false);
//		CellConstraints cc = new CellConstraints();
//
//		// Filter Panel
//		{
//
//			// Creating the combobox for selecting types
//			cbModel = new ComboBoxTypeModel();
//			cbModel.queryLetterTypes();
//			cbSearchModel = new ComboBoxSearchTypeModel(cbModel);
//			cbType = new JComboBox(cbSearchModel);
//			cbType.setSelectedIndex(0);
//
//			// Creating the panel for the filters
//			filterPanel = new HeaderedPanel();
//			filterPanel
//					.setLayout(new FormLayout(
//							"20dlu,70dlu,5dlu,60dlu,10dlu,30dlu,70dlu,15dlu,15dlu,70dlu,15dlu",
//							"15dlu"));
//			filterPanel.setBackground(BLUE_FRONT);
//			filterPanel
//					.setHeader(Translatrix
//							.getTranslationString("LetterTemplateModule.letterpanel.filter"));
//
//			// Filter: NAME
//			JLabel lFiltername = new JLabel(
//					Translatrix
//							.getTranslationString("LetterTemplateModule.letterpanel.name"));
//			filterPanel.add(lFiltername, cc.xy(1, 1));
//			tFilterName = new JTextField();
//			tFilterName.addCaretListener(new CaretListener() {
//				public void caretUpdate(CaretEvent e) {
//					filterName();
//				}
//
//			});
//
//			filterPanel.add(tFilterName, cc.xy(2, 1));
//
//			cbSearchModel.addListDataListener(cbType);
//			cbType.setEditable(false);
//			cbType.addActionListener(new ActionListener() {
//
//				public void actionPerformed(ActionEvent e) {
//					filterType();
//				}
//			});
//
//			filterPanel.add(cbType, cc.xy(4, 1));
//
//			JLabel lCreated = new JLabel(
//					Translatrix
//							.getTranslationString("LetterTemplateModule.letterpanel.createdbetween"));
//			filterPanel.add(lCreated, cc.xy(6, 1, CellConstraints.RIGHT,
//					CellConstraints.CENTER));
//			dBegin = new JDateChooser();
//			dBegin.addPropertyChangeListener(new PropertyChangeListener() {
//
//				public void propertyChange(PropertyChangeEvent evt) {
//					filterBeginDate();
//				}
//			});
//			filterPanel.add(dBegin, cc.xy(7, 1));
//
//			JButton lResetBegin = new JButton();
//			lResetBegin.setIcon(GECAMedModule
//					.getSmallIcon(GECAMedIconNames.CANCEL));
//			filterPanel.add(lResetBegin, cc.xy(8, 1));
//			lResetBegin.addActionListener(new ActionListener() {
//
//				public void actionPerformed(ActionEvent e) {
//					dBegin.setDate(null);
//					filterBeginDate();
//				}
//			});
//
//			JLabel lAnd = new JLabel(
//					Translatrix
//							.getTranslationString("LetterTemplateModule.letterpanel.and"));
//			filterPanel.add(lAnd, cc.xy(9, 1, CellConstraints.CENTER,
//					CellConstraints.CENTER));
//
//			dEnd = new JDateChooser();
//			dEnd.addPropertyChangeListener(new PropertyChangeListener() {
//
//				public void propertyChange(PropertyChangeEvent evt) {
//					filterEndDate();
//					if (dEnd.getDate() != null)
//						System.out.println(dEnd.getDate().toString());
//				}
//			});
//			dEnd.getDateEditor().setEnabled(false);
//
//			JButton lResetEnd = new JButton();
//			lResetEnd.setIcon(GECAMedModule
//					.getSmallIcon(GECAMedIconNames.CANCEL));
//			filterPanel.add(lResetEnd, cc.xy(11, 1));
//			lResetEnd.addActionListener(new ActionListener() {
//
//				public void actionPerformed(ActionEvent e) {
//					dEnd.setDate(null);
//					filterEndDate();
//
//				}
//			});
//
//			// dEnd.addPropertyChangeListener(JDateChooser., listener)
//			filterPanel.add(dEnd, cc.xy(10, 1));
//			filterPanel.setOpaque(true);
//
//			content.add(filterPanel, cc.xy(1, 1));
//		}
//
//		// Table Panel
//		{
//			tablePanel = new HeaderedPanel();
//			tablePanel.setLayout(new FormLayout("fill:300:grow",
//					"fill:300:grow"));
//			tablePanel.setBackground(BLUE_FRONT);
//			tablePanel
//					.setHeader(Translatrix
//							.getTranslationString("LetterTemplateModule.letterpanel.letters"));
//
//			menu = new JPopupMenu();
//
////			JMenuItem open = new JMenuItem(Translatrix
////					.getTranslationString("LetterTemplateModule.menu.open"));
////			open.addActionListener(new OpenLetterListener());
////			menu.add(open);
////
////			JMenuItem modify = new JMenuItem(Translatrix
////					.getTranslationString("LetterTemplateModule.menu.modify"));
////			modify.addActionListener(new ModifyLetterListener());
////			menu.add(modify);
////
////			JMenuItem rename = new JMenuItem(Translatrix
////					.getTranslationString("LetterTemplateModule.menu.rename"));
////			rename.addActionListener(new RenameLetterListener());
////			menu.add(rename);
////
////			JMenuItem delete = new JMenuItem(Translatrix
////					.getTranslationString("LetterTemplateModule.menu.delete"));
////			delete.addActionListener(new DeleteLetterListener());
////			menu.add(delete);
////
////			JMenuItem changeDescription = new JMenuItem(
////					Translatrix
////							.getTranslationString("LetterTemplateModule.menu.changedescription"));
////			changeDescription.addActionListener(new ChangeLetterDescription());
////			menu.add(changeDescription);
//
//			table = new JTable();
//			table.setGridColor(Color.WHITE);
//			// table.setBackground(BLUE_FRONT);
//			table.addMouseListener(new MouseListener() {
//
//				public void mouseClicked(MouseEvent e) {
////					if (e.getClickCount() == 2)
////						new OpenLetterListener().actionPerformed(null);
//				}
//
//				public void mouseEntered(MouseEvent e) {
//				}
//
//				public void mouseExited(MouseEvent e) {
//				}
//
//				public void mousePressed(MouseEvent e) {
//					showMenu(e);
//				}
//
//				public void mouseReleased(MouseEvent e) {
//					showMenu(e);
//				}
//			});
//			/* ------------------------------------------------------- */
//			// create a HistoryTableModel
//			/* ------------------------------------------------------- */
//			HistoryTableModel hModel = new HistoryTableModel(patientPanel.getHistoryDataAgent());
//			tableModel = new TableModel(hModel,	this);
//			
//			table.setModel(tableModel);
//			TableRenderer tableRenderer = new TableRenderer(tableModel);
//			table.getColumnModel().getColumn(0).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(0).setMinWidth(200);
//			table.getColumnModel().getColumn(1).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(2).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(3).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(4).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(5).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(6).setCellRenderer(tableRenderer);
//			table.getColumnModel().getColumn(7).setCellRenderer(tableRenderer);
//
//			JScrollPane scPane = new JScrollPane(table);
//			scPane.getViewport().setBackground(
//					GECAMedColors.c_GECAMedBackground);
//			tablePanel.add(scPane, cc.xy(1, 1));
//			content.add(tablePanel, cc.xy(1, 2));
//		}
//		// content.add
//		this.setBackground(GECAMedColors.c_GECAMedBackground);
//		this.setLayout(new FormLayout("5dlu,fill:100:grow,5dlu",
//				"5dlu,fill:100:grow,5dlu"));
//		this.add(content, cc.xy(2, 2));
//	}
//
//	protected void showMenu(MouseEvent e) {
//		table.setRowSelectionInterval(table.rowAtPoint(e.getPoint()), table
//				.rowAtPoint(e.getPoint()));
//		menu.show(table, e.getX(), e.getY());
//	}
//
//	@Override
//	public String getName() {
//		return NAME;
//	}
//
//	public List<HistRow> getTableData() {
//		return tableData;
//	}
//
//	/**
//	 * @param tableData
//	 */
//	public void setTableData(List<HistRow> tableData) {
//		/* ================================================== */
//		this.tableData 		= tableData;
//		this.typeData 		= tableData;
//		this.beginDateData  = tableData;
//		this.endDateData 	= tableData;
//		/* ================================================== */
//	}
//
//	public ComboBoxTypeModel getCbModel() {
//		return cbModel;
//	}
//
//	public static LetterPanel getInstance() {
//		return letterPanel;
//	}
//
//	private void filterName() {
//		ArrayList<HistRow> letters = new ArrayList<HistRow>();
//		if (tFilterName.getText().equalsIgnoreCase("")
//				|| tFilterName.getText().equalsIgnoreCase(" ")
//				|| tFilterName.getText() == "") {
//			tableModel.setData(typeData);
//		} else {
//			for (int i = 0; i < typeData.size(); i++) {
//				IncidentEntry entry = typeData.get(i).getEntry();
//				if (entry.getFileName().toLowerCase().startsWith(
//						tFilterName.getText().toLowerCase())) {
//					letters.add(typeData.get(i));
//				}
//			}
//			tableModel.setData(letters);
//		}
//	}
//
//	private void filterType() {
//		ArrayList<HistRow> letters = new ArrayList<HistRow>();
//		if (cbType.getSelectedIndex() != -1 && cbType.getSelectedItem() != null) {
//			if (cbType.getSelectedItem().toString().equalsIgnoreCase(
//					LetterTemplateModule.ALL)) {
//				typeData = beginDateData;
//			} else {
//				for (int i = 0; i < beginDateData.size(); i++) {
//
//					IncidentEntry entry = beginDateData.get(i).getEntry();
//
//					ArrayList<Letter> letterlist = (ArrayList<Letter>) letterManager
//							.getLetterByIncidentEntry(entry.getId());
//
//					if (letterlist.get(0).getType().toLowerCase().equals(
//							cbType.getSelectedItem().toString().toLowerCase())) {
//						letters.add(beginDateData.get(i));
//					}
//				}
//				typeData = letters;
//				// tableModel.setData(letters);
//			}
//			filterName();
//		}
//	}
//
//	private void filterBeginDate() {
//
//		ArrayList<HistRow> letters = new ArrayList<HistRow>();
//		if (dBegin.getDate() == null) {
//			beginDateData = endDateData;
//		} else {
//			for (int i = 0; i < endDateData.size(); i++) {
//
//				IncidentEntry entry = endDateData.get(i).getEntry();
//
//				if (entry.getCreated().compareTo(dBegin.getDate())> -1 ) {
//					letters.add(endDateData.get(i));
//				}
//			}
//			beginDateData = letters;
//		}
//
//		filterType();
//	}
//
//	private void filterEndDate() {
//
//		ArrayList<HistRow> letters = new ArrayList<HistRow>();
//		if (dEnd.getDate() == null) {
//			endDateData = tableData;
//		} else {
//			for (int i = 0; i < tableData.size(); i++) {
//
//				IncidentEntry entry = tableData.get(i).getEntry();
//
//				if (entry.getCreated().compareTo(dEnd.getDate()) <= 0) {
//					letters.add(tableData.get(i));
//				}
//			}
//			endDateData = letters;
//		}
//		filterBeginDate();
//	}
//
//	public JTable getTable() {
//		return table;
//	}
//
//	public void setTable(JTable table) {
//		this.table = table;
//	}
//}
