/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.gui.controller.document.DocumentController;

@javax.persistence.NamedQueries( {
		// findAll NamedQuery
		@NamedQuery(name = LetterTemplate.FIND_ALL, query = "SELECT OBJECT(o) FROM LetterTemplate o ORDER BY id DESC"),
		@NamedQuery(name = LetterTemplate.FIND_ALL_BY_PHYSICIAN_ID, query = "SELECT OBJECT(o) FROM LetterTemplate o WHERE o.physicianId = :physician_id OR o.share = true ORDER BY id DESC "),
		@NamedQuery(name = LetterTemplate.FIND_TYPES, query = "SELECT DISTINCT o.type FROM LetterTemplate o ORDER BY type ASC"),
		@NamedQuery(name = LetterTemplate.FIND_TYPES_BY_PHYSICIAN_ID, query = "SELECT DISTINCT o.type FROM LetterTemplate o WHERE o.physicianId = :physician_id OR o.share = true ORDER BY type ASC"),
		@NamedQuery(name = LetterTemplate.FIND_TEMPLATE_BY_NAME, query = "SELECT o FROM LetterTemplate o WHERE o.name = :name") })
@Entity
@Table(name = "templates", schema = "letter")
/*
 * Bean that represents a row in the table "letter.template" 
 */
public class LetterTemplate extends GECAMedEntityBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// Static fields
	public static final String FIND_ALL = "findAllLetterTemplates";

	public static final String FIND_ALL_BY_PHYSICIAN_ID = "findAllByPhysicianId";

	public static final String FIND_TYPES = "findTypesTemplate";
	
	public static final String FIND_TYPES_BY_PHYSICIAN_ID = "findTypesByPhsysicianId";
	
	public static final String FIND_TEMPLATE_BY_NAME = "findTemplateByName";
	

	// Attributes of a template, accessed by getter/setter methods
	private String name;

	private Date createdOn;

	private Date modifiedOn;

	private String description;

	private Integer createdBy;

	private Integer modifiedBy;

	// Id of the physician the template belongs to
	private Integer physicianId;

	// Type provides information by witch controller the template, internal
	// MIME_TYPE
	private String mimetype;

	// Name of the physical file on the server the bean belongs to
	private String generatedFileName;

	// Type of the template, context-specefic
	private String type;

	// Share template with all doctors of the office! Default is no
	private Boolean share;
	
	private String addressType;
	
	private Boolean requiresContact;
	
	private Integer	placeholderVersion;
	
	
	
	public LetterTemplate()
	{
		this.placeholderVersion	= DocumentController.PH_VERSION_NEW;
	}
	

	@Column(name = "name")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "created_on")
	public Date getCreatedOn() {
		return createdOn;
	}

	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	@Column(name = "description")
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "physician_id")
	public Integer getPhysicianId() {
		return physicianId;
	}

	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}

	@Column(name = "generated_filename")
	public String getGeneratedFileName() {
		return generatedFileName;
	}

	public void setGeneratedFileName(String generatedFileName) {
		this.generatedFileName = generatedFileName;
	}

	@Column(name = "mime_type")
	public String getMimetype() {
		return mimetype;
	}

	public void setMimetype(String mimetype) {
		this.mimetype = mimetype;
	}

	@Column(name = "type")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "share")
	public Boolean getShare() {
		if (share == null)
			return true;
		return share;
	}

	public void setShare(Boolean share) {
		this.share = share;
	}

	@Column(name = "modified_on")
	public Date getModifiedOn() {
		return modifiedOn;
	}

	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	@Column(name = "created_by")
	public Integer getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "modified_by")
	public Integer getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(Integer modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * @return the addressType
	 */
	@Column(name="addresstype")
	public String getAddressType() {
		/* ====================================================== */
		return addressType;
		/* ====================================================== */}

	/**
	 * @param addressType the addressType to set
	 */
	public void setAddressType(String addressType) {
		/* ====================================================== */
		this.addressType = addressType;
		/* ====================================================== */}

	/**
	 * @return the requiresContact
	 */
	@Column(name="requires_contact")
	public Boolean getRequiresContact() {
		/* ====================================================== */
	    	if (requiresContact != null)
	    	    return requiresContact;
	    	else
	    	    return false;
		/* ====================================================== */}

	/**
	 * @param requiresContact the requiresContact to set
	 */
	public void setRequiresContact(Boolean requiresContact) {
		/* ====================================================== */
		this.requiresContact = requiresContact;
		/* ====================================================== */
	}
	
	
	@Column(name="placeholder_version")
	public Integer getPlaceholderVersion ()
	{
		return placeholderVersion;
	}
	
	
	public void setPlaceholderVersion (Integer version)
	{
		this.placeholderVersion = version;
	}
}
