package lu.tudor.santec.gecamed.letter.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


@NamedQueries(
{
	@NamedQuery(
			name = LetterPlaceholder.GET_PLACEHOLDER_TYPES,
			query = "SELECT DISTINCT(p.type) FROM LetterPlaceholder p " +
					"WHERE p.type IS NOT NULL " +
					"ORDER BY p.type ASC"),
	@NamedQuery(
			name = LetterPlaceholder.GET_PLACEHOLDER_NAMES_BY_TYPE,
			query = "SELECT p.name FROM LetterPlaceholder p " +
					"WHERE p.type = :type " +
					"AND p.type IS NOT NULL " +
					"ORDER BY p.name ASC"),
	@NamedQuery(
			name = LetterPlaceholder.GET_PLACEHOLDERS_BY_TYPE,
			query = "SELECT OBJECT(p) FROM LetterPlaceholder p " +
					"WHERE p.type = :type " + 
					"AND p.name IS NOT NULL " +
					"ORDER BY p.name ASC"),
	@NamedQuery(
			name = LetterPlaceholder.GET_PLACEHOLDERS_BY_NAMES,
			query = "SELECT OBJECT(p) FROM LetterPlaceholder p " +
					"WHERE p.name IN (:names) " +
					"ORDER BY p.name"),
	@NamedQuery(
			name = LetterPlaceholder.GET_PLACEHOLDER_NAMES_BY_NAMES,
			query = "SELECT p.name FROM LetterPlaceholder p " +
					"WHERE p.name IN (:names) " +
					"ORDER BY p.name"),
	@NamedQuery(
			name = LetterPlaceholder.GET_CONTACT_PLACEHOLDER_NAMES,
			query = "SELECT p.name FROM LetterPlaceholder p " +
					"WHERE UPPER(p.type) = 'CONTACT' " +
					"OR UPPER(p.type) LIKE 'CONTACT_%' " +
					"ORDER BY p.type, p.name"),
	@NamedQuery(
			name = LetterPlaceholder.GET_FUNCTIONS_FOR_TYPES,
			query = "SELECT OBJECT(f) FROM LetterPlaceholder f " +
					"WHERE name IS NULL " +
					"AND " +
					"(" +
					"   type IS NULL " +
					"OR type IN (:types) " +
					")" +
					"ORDER BY type "),
	@NamedQuery(
			name = LetterPlaceholder.GET_FUNCTIONS_FOR_TYPE,
			query = "SELECT OBJECT(f) FROM LetterPlaceholder f " +
					"WHERE name IS NULL " +
					"AND type = :type ")
})
@Entity
@Table( name = "placeholders", schema = "letter")
public class LetterPlaceholder extends GECAMedEntityBean
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	public static final String	GET_PLACEHOLDERS_BY_NAMES		= "GetPlaceholdersByName";
	public static final String	GET_PLACEHOLDER_NAMES_BY_NAMES	= "GetPlaceholdersNamesByName";
	public static final String	GET_PLACEHOLDER_TYPES			= "GetPlaceholderType";
	public static final String	GET_PLACEHOLDER_NAMES_BY_TYPE	= "GetPlaceholderNamesByType";
	public static final String	GET_CONTACT_PLACEHOLDER_NAMES	= "GetContactPlaceholderNames";
	public static final String	GET_PLACEHOLDERS_BY_TYPE		= "GetPlaceholdersByType";
	public static final String	GET_FUNCTIONS_FOR_TYPES			= "GetFunctionsForTypes";
	public static final String	GET_FUNCTIONS_FOR_TYPE			= "GetFunctionsForType";
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String	name;
	
	private String	type;
	
	private String	comment;
	
	private String	script;
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	@Column(name = "name")
	public String getName()
	{
		return name;
	}
	
	
	public void setName(String name)
	{
		this.name = name;
	}
	

	@Column(name = "type")
	public String getType()
	{
		return type;
	}
	
	
	public void setType(String type)
	{
		this.type = type;
	}
	

	@Column(name = "comment")
	public String getComment()
	{
		return comment;
	}
	
	
	public void setComment(String comment)
	{
		this.comment = comment;
	}
	

	@Column(name = "script")
	public String getScript()
	{
		return script;
	}
	
	
	public void setScript(String script)
	{
		this.script = script;
	}
	
	
	@Override
	@Transient
	public String toString() 
	{
		return name;
	}
}
