<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:xalan="http://xml.apache.org/xalan">

<xsl:output method="html"/>

<xsl:include href="html_common.xsl"/>
	
<xsl:template match="/">
 	<html>
 		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<xsl:call-template name="ResultStyles"/>
 			<title>Labor Resultate</title>
 		</head>	
 		
 		<body bgcolor="#FFFFFF" text="#000000" link="#003366" alink="#0099FF" vlink="#00CC99">
 			
 			<table width="100%" cellpadding="5">
 				<tr>
 					<td width="50%" align="left">
 						<h1><xsl:apply-templates select="File/Record/Body/Sender/Organisation/OrganisationName"/></h1>
 						
 						<xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/Street"/>
 						<br/>
 						<xsl:if test="File/Record/Body/Sender/Organisation/Address/POBox">
 							Postfach:<xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/POBox"/>
 							<br/>
 						</xsl:if>
 						
						<xsl:if test="File/Record/Body/Sender/Organisation/Address/CountryCode">
		    				<xsl:call-template name="uppercase">
        						<xsl:with-param name="p_Text" select="substring(File/Record/Body/Sender/Organisation/Address/CountryCode,1,1)"/>
      						</xsl:call-template>
      						-
 						</xsl:if>
 						
 						<xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/ZipCode"/>
 						&#xA0;
 						<xsl:call-template name="uppercase">
        					<xsl:with-param name="p_Text" select="File/Record/Body/Sender/Organisation/Address/Town"/>
      					</xsl:call-template>					
 						<br/>
 						<xsl:if test="File/Record/Body/Sender/Organisation/EMail">
 							EMail:<xsl:apply-templates select="File/Record/Body/Sender/Organisation/EMail"/>
 						</xsl:if>
 						
 					</td>
 					
 					<td width="50%" align="left">
 						
 						<b>Kontakt:</b> 
 						<xsl:call-template name="uppercase">
        					<xsl:with-param name="p_Text" select="File/Record/Body/Sender/Organisation/ContactPerson/LastName"/>
      					</xsl:call-template>
      					&#xA0;
 						<xsl:apply-templates select="File/Record/Body/Sender/Organisation/ContactPerson/FirstName"/>
 						<br/>
 						<xsl:apply-templates select="File/Record/Body/Sender/Organisation/ContactPerson/Function"/>
 						<br/>
 						
 						<xsl:if test="File/Record/Body/Sender/Organisation/Phone">
								<b>Telefon:</b><xsl:apply-templates select="File/Record/Body/Sender/Organisation/Phone"/>
								<br/>
						</xsl:if>					
 						
 						<xsl:if test="File/Record/Body/Sender/Organisation/GSM">
								<b>GSM:</b><xsl:apply-templates select="File/Record/Body/Sender/Organisation/GSM"/>
								<br/>
						</xsl:if>					
 						
 						<xsl:if test="File/Record/Body/Sender/Organisation/Fax">
								<b>Fax:</b><xsl:apply-templates select="File/Record/Body/Sender/Organisation/Fax"/>
								<br/>
						</xsl:if>
					
					</td>
				</tr>
				
				<tr>
					<td bgcolor="#bbbbbb"><h2>PATIENT</h2></td>
					<td bgcolor="#bbbbbb"><h2>VERSCHREIBER</h2></td>
				</tr>
				
				<tr>
					<td bgcolor="#dddddd">
						
						<b>	<xsl:call-template name="uppercase">
        						<xsl:with-param name="p_Text" select="File/Record/Body/Patient/Person/LastName"/>
      						</xsl:call-template>
      						&#xA0;					
						    <xsl:apply-templates select="File/Record/Body/Patient/Person/FirstName"/></b>
                		<br/>
 						(Matrikelnummer:<xsl:apply-templates select="File/Record/Header/SSNPatient"/>)
 						<br/>
 						<xsl:if test="File/Record/Body/Patient/Person/Refext"> 
  			 				Externe Referenz:<xsl:apply-templates select="File/Record/Body/Patient/Person/Refext"/>
							<br/>
						</xsl:if>
 						<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/Street"/>
 						<br/>
 						<xsl:if test="File/Record/Body/Patient/Person/Address/POBox">
							Postfach:<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/POBox"/>
							<br/>
						</xsl:if>
						<xsl:if test="File/Record/Body/Patient/Person/Address/CountryCode">
		    				<xsl:call-template name="uppercase">
        						<xsl:with-param name="p_Text" select="substring(File/Record/Body/Patient/Person/Address/CountryCode,1,1)"/>
      						</xsl:call-template>
      						-
						</xsl:if>
 						<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/ZipCode"/>
 						&#xA0;
 						<xsl:value-of select="translate(File/Record/Body/Patient/Person/Address/Town,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/> 
 						<br/>
 						<xsl:if test="File/Record/Body/Patient/Person/Phone">
 							<b>Tél:</b> <xsl:apply-templates select="File/Record/Body/Patient/Person/Phone"/>
 						</xsl:if>						
 					</td>
 					
 					<td bgcolor="#dddddd">
 						
 						<xsl:if test="File/Record/Body/Destination/Organisation/OrganisationName">
 							<h2><xsl:apply-templates select="File/Record/Body/Destination/Organisation/OrganisationName"/></h2>
 							zdH.
 						</xsl:if>
 						
 						<b><xsl:call-template name="uppercase">
        						<xsl:with-param name="p_Text" select="File/Record/Body/Destination/Organisation/ContactPerson/LastName"/>
      						</xsl:call-template>
      						&#xA0;
                		    <xsl:apply-templates select="File/Record/Body/Destination/Organisation/ContactPerson/FirstName"/></b> 
 						<br/>
 						<xsl:if test="File/Record/Body/Destination/Organisation/ContactPerson/Function">
							<xsl:apply-templates select="File/Record/Body/Destination/Organisation/ContactPerson/Function"/>
						</xsl:if>
						<br/>
 						<xsl:if test="File/Record/Header/CodePrescriterUCM">
							<b>Arztcode:</b> <xsl:apply-templates select="File/Record/Header/CodePrescriterUCM"/>
						</xsl:if>	
 						<br/>
 						<xsl:value-of select="File/Record/Body/Destination/Organisation/Address/Street"/>
 						<br/>
 						<xsl:if test="File/Record/Body/Destination/Organisation/Address/POBox">
							<b>Postfach:</b> <xsl:apply-templates select="File/Record/Body/Destination/Organisation/Address/POBox"/>
						</xsl:if>
 						<xsl:if test="File/Record/Body/Destination/Organisation/Address/CountryCode">
		    				<xsl:call-template name="uppercase">
        						<xsl:with-param name="p_Text" select="substring(File/Record/Body/Destination/Organisation/Address/CountryCode,1,1)"/>
      						</xsl:call-template>
      						-
						</xsl:if>
 						<xsl:apply-templates select="File/Record/Body/Destination/Organisation/Address/ZipCode"/> 
 						&#xA0;
  						<xsl:call-template name="uppercase">
        					<xsl:with-param name="p_Text" select="File/Record/Body/Destination/Organisation/Address/Town"/>
      					</xsl:call-template>						 						
 					</td>
 				</tr>
 				<tr>
 					<td bgcolor="#f0f0f0">
 						<table>
 							<tr>
 								<td><b>Untersuchungsdatum:</b></td>
 								<td><xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@day"/>/<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@month"/>/<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@year"/>
 								    <xsl:if test="/File/Record/Body/ExaminationDate/Date/@hour">
 								    	um
 								   	    <xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@minute"/>
 									</xsl:if>
 								</td>
							</tr>
							<tr>
								<td><b>Probedatum:</b></td>
								<td><xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@day"/>/<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@month"/>/<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@year"/>
									<xsl:if test="/File/Record/Body/SpecimenDate/Date/@hour">
										um
										<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@minute"/>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td><b>Verschreibungsdatum:</b></td>
								<td><xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@day"/>/<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@month"/>/<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@year"/>
									<xsl:if test="/File/Record/Body/PrescriptionDate/Date/@hour">
										um
										<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@minute"/>
									</xsl:if>
								</td>
							</tr>
						</table>
					</td>
					
					<td bgcolor="#dddddd">
						
						<xsl:if test="File/Record/Body/Destination/Organisation/Phone">
							<b>Telefon:</b><xsl:apply-templates select="File/Record/Body/Destination/Organisation/Phone"/>
							<br/>
						</xsl:if>
						<xsl:if test="File/Record/Body/Destination/Organisation/GSM">
							<b>GSM:</b><xsl:apply-templates select="File/Record/Body/Destination/Organisation/GSM"/>
							<br/>
						</xsl:if>
						<xsl:if test="File/Record/Body/Destination/Organisation/Fax">
							<b>Fax:</b><xsl:apply-templates select="File/Record/Body/Destination/Organisation/Fax"/>
							<br/>
						</xsl:if>
						<xsl:if test="File/Record/Body/Destination/Organisation/EMail">
							<b>Email:</b><xsl:apply-templates select="File/Record/Body/Destination/Organisation/EMail"/>
							<br/>
						</xsl:if>
						
					</td>
				</tr>
				<tr>
					<td colspan="2">
 						<h2>Anmerkungen:</h2>
 						<xsl:choose>
 							<xsl:when test="not($c_TemplateMode = 'LINEBREAKS')">
 								<xsl:call-template name="break">
        							<xsl:with-param name="p_Text" select="File/Record/Body/RecordComments"/>
      							</xsl:call-template>					
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="File/Record/Body/RecordComments"/>
							</xsl:otherwise>
						</xsl:choose>
 					</td>
 				</tr>
 			</table>
 			
 			<table width="100%">
 				<tr><td colspan="2"><hr noshade="true" size="1"/></td></tr>	
 				<tr>
 					<td align="left"> <h2>Resultat</h2></td>
 					<td align="right"><h2>Referenz Nummer: <xsl:apply-templates select="/File/Record/Body/ReferenceNumber"/></h2></td>
 				</tr>
 				<tr><td colspan="2"><hr noshade="true" size="1"/></td></tr>
 			</table>

 			<table width="100%">
 				<tr>
 					<th class="inverse"></th>
 					<th class="inverse" align="left"><b>Beschreibung (LOINC)</b></th>
 					<th class="inverse" align="right"><b>Wert</b></th>
 					<th class="inverse" align="center"><b>Einheit</b></th>
 					<th class="inverse" align="right"><b>Referenz</b></th>
 					<th class="inverse" align="right"><b>Vorheriger Wert</b></th>
 					<th class="inverse" align="center"><b>Alarm</b></th>
 				</tr>
 				
 				<xsl:for-each select="File/Record/Result">
 				
					<xsl:if test="Title">
						<tr><td colspan="7"><h1><xsl:apply-templates select="Title"/></h1></td></tr>
					</xsl:if>
						
					<xsl:if test="SubTitle">
						<tr><td colspan="7"><h2><xsl:apply-templates select="SubTitle"/></h2></td></tr>
					</xsl:if>
										
					<xsl:choose>
						<xsl:when test="Alarm[not(. = '')]">
							<xsl:if test="Alarm[(. = '+')]">
								 <xsl:call-template name="displayDetailedResultLine">
									<xsl:with-param name="p_Result" select="."/>
									<xsl:with-param name="p_ResultTableLabel" select="'Komplexes Resultat'"/>
									<xsl:with-param name="p_ResultCommentLabel" select="'Anmerkung'"/>
									<xsl:with-param name="p_Style" select="'alarm-over'"/>
								</xsl:call-template>
							</xsl:if>    
							<xsl:if test="Alarm[(. = '-')]">
								 <xsl:call-template name="displayDetailedResultLine">
									<xsl:with-param name="p_Result" select="."/>
									<xsl:with-param name="p_ResultTableLabel" select="'Komplexes Resultat'"/>
									<xsl:with-param name="p_ResultCommentLabel" select="'Anmerkung'"/>
									<xsl:with-param name="p_Style" select="'alarm-under'"/>
								</xsl:call-template>
							</xsl:if>    
							<xsl:if test="Alarm[(. = '!')]">
								 <xsl:call-template name="displayDetailedResultLine">
									<xsl:with-param name="p_Result" select="."/>
									<xsl:with-param name="p_ResultTableLabel" select="'Komplexes Resultat'"/>
									<xsl:with-param name="p_ResultCommentLabel" select="'Anmerkung'"/>
									<xsl:with-param name="p_Style" select="'alarm-pathologic'"/>
								</xsl:call-template>
							</xsl:if>    
 						</xsl:when>
						<xsl:otherwise>	
                        	<xsl:call-template name="displayDetailedResultLine">
								<xsl:with-param name="p_Result" select="."/>
								<xsl:with-param name="p_ResultTableLabel" select="'Komplexes Resultat'"/>
								<xsl:with-param name="p_ResultCommentLabel" select="'Anmerkung'"/>
								<xsl:with-param name="p_Style"></xsl:with-param>
                            </xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
								
				</xsl:for-each>

 			</table>
 			
			<xsl:for-each select="File/Record/Bacteriology">
				
				<hr noShade="true" size="1" />
	
				<h1><xsl:apply-templates select="Title"/></h1>
			
				<h2>Kulturen</h2>
			
				<table width="75%">
					<xsl:for-each select="Culture">
						<tr>
							<td><xsl:apply-templates select="CultureID"/></td>
							<td><xsl:apply-templates select="CultureName"/></td>
							<td nowrap="nowrap"><xsl:apply-templates select="CultureConcentration"/></td>
							<td nowrap="nowrap"><xsl:apply-templates select="Unit"/></td>
						</tr>
					</xsl:for-each>	
				</table>
	
				<h2>Antibiogramm</h2>
				<xsl:if test="Unit">                            
					<small>MHK Werte in <xsl:apply-templates select="Unit"/></small>
				</xsl:if>
			
				<table width="100%">
					<tr>
						<th class="inverse" align="left">Testsubstanz</th>
						<th class="inverse" align="left"><b>1 MHK</b></th>
						<th class="inverse" align="left"><b>2 MHK</b></th>
						<th class="inverse" align="left"><b>3 MHK</b></th>
						<th class="inverse" align="left"><b>4 MHK</b></th>
					</tr>
	
					<xsl:for-each select="Antibiogram/Test">         
						<xsl:call-template name="displayAntibiogramLine">
							<xsl:with-param name="p_Test"  select="."/>
							<xsl:with-param name="p_Count"><xsl:number count="Antibiogram/Test" format="1"/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>				
				</table>                            
 			</xsl:for-each>
 			
            <hr noShade="true" size="1" />
 			
			<table width="100%">
				<tr>
					<td width="50%" align="left">
						Untersuchungsstatus: <xsl:apply-templates select="/File/Record/Body/ExaminationStatus"/> 
					</td>
					<td width="50%" align="right">
						Eintragsstatus: <xsl:apply-templates select="/File/Record/Body/RecordStatus"/> 
					</td>
				</tr>
			</table>
 		
 		</body>
 	</html>
</xsl:template> 
 
</xsl:stylesheet>