/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.patientview;

import java.util.Collection;
import java.util.Date;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.ResultStub;
import lu.tudor.santec.i18n.Translatrix;

public class ResultStubListModel extends AbstractTableModel
	{

	/**
	 * 
	 */

	private Vector <ResultStub> m_Results;
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	private static final long serialVersionUID = 1L;

	public static final Date c_Epoch = new Date (0);

	public static final String c_LaboratoryHeader 			= "ResultStubListModel.LaboratoryHeader";
	public static final String c_ExaminationDateHeader 		= "ResultStubListModel.ExaminationDateHeader";
    public static final String c_ExaminationStatusHeader	= "ResultStubListModel.ExaminationStatusHeader";
    public static final String c_ResultStatusHeader			= "ResultStubListModel.ResultStatusHeader";
 
    public static final int c_LaboratoryColumn 			= 0;
    public static final int c_ExaminationDateColumn 	= 1;
    public static final int c_ExaminationStatusColumn 	= 2;
    public static final int c_ResultStatusColumn 		= 3;

    public static final  String m_TableHeaders [] =  { 	c_LaboratoryHeader,
    												    c_ExaminationDateHeader,
    												    c_ExaminationStatusHeader,
    												    c_ResultStatusHeader };
    
     
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public ResultStubListModel ()
	{
	m_Results = new Vector <ResultStub> ();	
	}
    
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < m_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(m_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (m_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Results.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
	{
    ResultStub  l_Result = null;
     
    if ((p_Row >= 0) && (p_Row < m_Results.size()))
        {
    	l_Result = m_Results.elementAt (p_Row);
        }
	
    if (l_Result == null) return "";
    
    switch (p_Column)
        {
        case  c_LaboratoryColumn      	: return (l_Result.getLaboratoryName() != null)?l_Result.getLaboratoryName():"";
        case  c_ExaminationDateColumn   : return (l_Result.getExaminationDate() != null)?l_Result.getExaminationDate():c_Epoch;
        case  c_ExaminationStatusColumn : return (l_Result.getExaminationStatus() != null)?l_Result.getExaminationStatus():"";
        case  c_ResultStatusColumn 		: return (l_Result.getResultStatus() != null)?l_Result.getResultStatus():"";
     
        default: return "";
        }
 	}

//---------------------------------------------------------------------------

public ResultStub getResultStubAt (int p_Row)
	{
	if ((p_Row >= 0) && (p_Row < this.getRowCount()))	
		 return m_Results.elementAt(p_Row);
	else return null;
	}

//---------------------------------------------------------------------------

public int findResultStub (ResultStub p_Result)
	{
	int			l_Row 	= 0;
	boolean		l_Found = false;
	ResultStub	l_Result;
	
	
	if (p_Result == null) return -1;
		
	while (!l_Found && (l_Row < m_Results.size()))	
		{
		l_Result = m_Results.elementAt(l_Row);
		if (l_Result.equals(p_Result))
			l_Found = true;
		else l_Row++;
		}
	
	if (!l_Found) l_Row = -1;
	
	return l_Row;
	}

//---------------------------------------------------------------------------

public void setResultStubs (Collection <ResultStub> p_Results)
	{
	int	l_LastRow;
	
	l_LastRow = this.getRowCount() - 1;
	m_Results.removeAllElements();	
	if (l_LastRow > 0) this.fireTableRowsDeleted (0, l_LastRow);
	
	if ((p_Results != null) && (p_Results.size() > 0))
		{
		m_Results.addAll(p_Results);	
		this.fireTableRowsInserted(0, p_Results.size());
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
