/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.patientview;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;

import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.widgets.GenericListBox;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.ResultStub;
import lu.tudor.santec.gecamed.labo.gui.event.result.ResultChangeEvent;
import lu.tudor.santec.gecamed.labo.gui.event.result.ResultEventDispatcher;
import lu.tudor.santec.gecamed.labo.gui.event.result.ResultEventSource;
import lu.tudor.santec.gecamed.labo.gui.event.result.ResultListener;
import lu.tudor.santec.i18n.Relocalizable;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class ResultPanel extends JPanel implements ResultEventSource,
												   Relocalizable
	{
	/**
	 * 
	 */
	
	private GenericListBox			m_ResultStubListBox;	
	private ResultStubListModel		m_ResultStubs;	
	private ResultStubRenderer		m_ResultStubRender;
	
	private ResultEventDispatcher	m_ResultEventDispatcher;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;

	private final static String c_Columns= "3dlu,fill:pref:grow,3dlu";		
	private final static String c_Rows=    "3dlu,fill:pref:grow:3dlu";

	private static final int	c_ColumnWidths[]  =  {  35,35,15,15 };

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public ResultPanel ()
	{
	this.buildPanel();	
	m_ResultEventDispatcher = new ResultEventDispatcher ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private void buildPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
 	MouseAdapter	l_MouseAdapter;
	
	l_Constraints  	= new CellConstraints();
	l_Layout		= new FormLayout(c_Columns, c_Rows);
		
	this.setLayout (l_Layout); 
	this.setOpaque(false);

	m_ResultStubs = new ResultStubListModel ();
	
	m_ResultStubRender = new ResultStubRenderer ();
	
	m_ResultStubListBox = new GenericListBox (m_ResultStubs);	
	m_ResultStubListBox.setRenderer (m_ResultStubRender);
	m_ResultStubListBox.setColumnWidths(c_ColumnWidths);
	
  	l_MouseAdapter = new MouseAdapter()
		{
		public void mouseClicked(MouseEvent p_Event)
			{
			if (p_Event.getClickCount() == 2)
				{
				openSelectedResult (); 
				}
			}
		};

	m_ResultStubListBox.addMouseListener(l_MouseAdapter);

	this.add (m_ResultStubListBox, 	 l_Constraints.xywh (2, 2, 1, 1));	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void openSelectedResult ()
	{
	int					l_SelectedRow;
	ResultStub			l_ResultStub;
	ResultChangeEvent	l_Event;
	
	l_SelectedRow = m_ResultStubListBox.getSelectedRow();
	l_ResultStub  = m_ResultStubs.getResultStubAt (l_SelectedRow);
	
	l_Event = new ResultChangeEvent (this,ResultChangeEvent.c_ResultOpened,l_ResultStub.getId());
	m_ResultEventDispatcher.notifyResultListeners(l_Event);
	}

//---------------------------------------------------------------------------

public ResultStub getSelectedResult ()
	{
	int					l_SelectedRow;
	ResultStub			l_ResultStub;
	
	l_SelectedRow = m_ResultStubListBox.getSelectedRow();
	l_ResultStub  = m_ResultStubs.getResultStubAt (l_SelectedRow);
	
	return l_ResultStub;
	}

//---------------------------------------------------------------------------

public boolean selectResult (ResultStub p_ResultStub)
	{
	int	l_Row;
		
	l_Row = m_ResultStubs.findResultStub(p_ResultStub);	
	if (l_Row >= 0) 
		{
		m_ResultStubListBox.setSelectedRow(l_Row);
		return true;
		}
	else return false;
	}

//---------------------------------------------------------------------------

public void setResultStubs (Collection <ResultStub> p_ResultStubs)
	{
	m_ResultStubs.setResultStubs(p_ResultStubs);
	m_ResultStubListBox.validate();
	}

//---------------------------------------------------------------------------

public void relocalize()
	{
	if (m_ResultStubRender != null)  m_ResultStubRender.relocalize();
	if (m_ResultStubListBox != null) m_ResultStubListBox.relocalize();
	}

//---------------------------------------------------------------------------

public void addResultListener(ResultListener p_Listener)
	{
	m_ResultEventDispatcher.addResultListener(p_Listener);
	}

//---------------------------------------------------------------------------

public void removeResultListener(ResultListener p_Listener)
	{
	m_ResultEventDispatcher.removeResultListener(p_Listener);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
