/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.history;

import java.util.Date;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.ResultStub;
import lu.tudor.santec.i18n.Translatrix;

import org.jdesktop.swingx.treetable.TreeTableModel;

import bizcal.util.DateUtil;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class HistoryTreeTableModel implements TreeTableModel
	{
 	private static final long serialVersionUID = 1L;
 
 	private HistoryNode m_Root;
 	
 	private static Date	m_Today = HistoryNode.stripTime (new Date ());
 	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

 	public static final Date c_Epoch = new Date (0);

	private static final String c_DayHeader		 			= "HistoryTreeTableModel.DayHeader";
    private static final String c_PatientNameHeader		 	= "HistoryTreeTableModel.PatientNameHeader";
    private static final String c_PatientSSNHeader		 	= "HistoryTreeTableModel.PatientSSNHeader";
    private static final String c_LaboratoryHeader 			= "HistoryTreeTableModel.LaboratoryHeader";
    private static final String c_ExaminationDateHeader 	= "HistoryTreeTableModel.ExaminationDateHeader";
    private static final String c_ExaminationStatusHeader	= "HistoryTreeTableModel.ExaminationStatusHeader";
    private static final String c_ResultStatusHeader		= "HistoryTreeTableModel.ResultStatusHeader";
       
    public static final int		c_DayColumn					= 0;
    public static final int		c_PatientNameColumn			= 1;
    public static final int		c_PatientSSNColumn			= 2;
    public static final int		c_LaboratoryColumn			= 3;
    public static final int		c_ExaminationDateColumn		= 4;
    public static final int		c_ExaminationStatusColumn	= 5;
    public static final int		c_ResultStatusColumn		= 6;
        
    private static final String c_TableHeaders [] = { 	c_DayHeader,
    													c_PatientNameHeader,
    													c_PatientSSNHeader,
    													c_LaboratoryHeader,
    													c_ExaminationDateHeader,
    													c_ExaminationStatusHeader,
    													c_ResultStatusHeader };
 	
    private static final String c_Today					= "HistoryTreeTableModel.Today";
    private static final String c_Yesterday				= "HistoryTreeTableModel.Yesterday";
    private static final String c_2DaysAgo				= "HistoryTreeTableModel.2DaysAgo";
    private static final String c_3DaysAgo				= "HistoryTreeTableModel.3DaysAgo";
    private static final String c_4DaysAgo				= "HistoryTreeTableModel.4DaysAgo";
    private static final String c_5DaysAgo				= "HistoryTreeTableModel.5DaysAgo";
    private static final String c_6DaysAgo				= "HistoryTreeTableModel.6DaysAgo";

    private static final String c_Days [] 		 = { c_Today,
    										  		 c_Yesterday,
    										  		 c_2DaysAgo,
    										  		 c_3DaysAgo,
    										  		 c_4DaysAgo,
    										  		 c_5DaysAgo,
    										  		 c_6DaysAgo };
    
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public  HistoryTreeTableModel ()
	{
	m_Root = new HistoryNode ();
	m_Today = HistoryNode.stripTime (new Date ());
	}
    
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public static String formatDayEntry (HistoryNode p_Node)
	{
	int	l_DaysAgo;
		
		if (p_Node == null) return "";
		
	if (p_Node.getDay() != null)
		{
		l_DaysAgo = DateUtil.getDateDiff(m_Today, p_Node.getDay());
		if ((l_DaysAgo >= 0) && (l_DaysAgo < c_Days.length))
			 return Translatrix.getTranslationString(c_Days [l_DaysAgo]);
		else return "";
		}
	
	else return "Root";	
	}
    
//---------------------------------------------------------------------------

private String getPatientName (ResultStub p_ResultStub)
	{
	String  l_Name		= "-";

	if (p_ResultStub != null)
		{
		l_Name = (p_ResultStub.getPatientName() != null) ? p_ResultStub.getPatientName().toUpperCase() : "";
		l_Name += " ";
		l_Name += (p_ResultStub.getPatientFirstName() != null) ? p_ResultStub.getPatientFirstName() : "";
		}

	return l_Name;
	}

//---------------------------------------------------------------------------

private String getPatientSSN (ResultStub p_ResultStub)
	{
	String  l_SSN		= "-";

	if (p_ResultStub != null && p_ResultStub.getPatientSSN() != null)
		{
//		l_SSN = Patient.formatSocialSecurityNumber(p_ResultStub.getPatientSSN());
		l_SSN = p_ResultStub.getPatientSSN();
		}

	return l_SSN;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (1);
    }

//---------------------------------------------------------------------------

public int getHierarchicalColumn()
	{
	return c_DayColumn;
	}

//---------------------------------------------------------------------------

public Object getValueAt (Object p_Node, int p_Column)
	{
	ResultStub l_ResultStub;
	
	if (p_Node instanceof HistoryNode)
		{
		l_ResultStub = ((HistoryNode)p_Node).getResultStub();
		if (l_ResultStub != null)
			{
			switch (p_Column)
				{
				case c_PatientNameColumn: 	 	return this.getPatientName (l_ResultStub);       
				case c_PatientSSNColumn: 	 	return this.getPatientSSN (l_ResultStub);       
				case c_LaboratoryColumn: 		return (l_ResultStub.getLaboratoryName() != null) ? l_ResultStub.getLaboratoryName()   : "";
				case c_ExaminationDateColumn: 	return (l_ResultStub.getExaminationDate() != null) ? l_ResultStub.getExaminationDate()   : c_Epoch;
				case c_ExaminationStatusColumn: return (l_ResultStub.getExaminationStatus() != null) ? l_ResultStub.getExaminationStatus()   : "";
				case c_ResultStatusColumn:      return (l_ResultStub.getResultStatus() != null) ? l_ResultStub.getResultStatus()   : "";
				default:						return "";
				}
			}
		else
			{
			switch (p_Column)
				{
				case c_DayColumn:		return formatDayEntry ((HistoryNode)p_Node);
				default:				return "";
				}
			}
		}

	return "";		
	}

//---------------------------------------------------------------------------

public void setValueAt (Object p_Value, Object p_Node, int p_Column)
	{
	}

//---------------------------------------------------------------------------

public Class<?> getColumnClass (int p_Column)
	{
	HistoryNode	l_Node;
	
	l_Node = new HistoryNode ();
	return this.getValueAt(l_Node, p_Column).getClass();	
	}

//---------------------------------------------------------------------------

public boolean isCellEditable (Object p_Node, int p_Column)
	{
	return false;
	}

//---------------------------------------------------------------------------

public int getChildCount (Object p_Node)
	{
	HistoryNode l_Node;	
		
	if (p_Node instanceof HistoryNode)
		{
		l_Node = (HistoryNode) p_Node;
		return l_Node.getChildCount();
		}
	else return 0;
	}

//---------------------------------------------------------------------------

public Object getChild (Object p_Node, int p_Index)
	{
	HistoryNode l_Node;	
		
	if (p_Node instanceof HistoryNode)
		{
		l_Node = (HistoryNode) p_Node;
		return l_Node.getChildAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getIndexOfChild (Object p_Parent, Object p_Child)
	{
	HistoryNode l_Parent;	
	HistoryNode l_Child;	

	if (	(p_Parent instanceof HistoryNode)
		 && (p_Child instanceof HistoryNode))
		{
		l_Parent = (HistoryNode) p_Parent;
		l_Child  = (HistoryNode) p_Child;
		return l_Parent.getIndex (l_Child);
		}	
	else return 0;
	}

//---------------------------------------------------------------------------

public boolean isLeaf (Object p_Node)
	{
	HistoryNode l_Node;	
		
	if (p_Node instanceof HistoryNode)
		{
		l_Node = (HistoryNode) p_Node;
		return l_Node.isLeaf();
		}
	else return false;
	}

//---------------------------------------------------------------------------

public void addTreeModelListener (TreeModelListener arg0)
	{
	}

//---------------------------------------------------------------------------

public Object getRoot()
	{	
	return m_Root;
	}

//---------------------------------------------------------------------------

public void removeTreeModelListener (TreeModelListener arg0)
		{
		}

//---------------------------------------------------------------------------

public void valueForPathChanged (TreePath arg0, Object arg1)
		{
		}

//---------------------------------------------------------------------------

public void setRoot (HistoryNode p_RootNode)
	{
	if (m_Root != null) m_Root.removeAllChildren ();
		
	m_Root = p_RootNode;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Clas                                                             *
//***************************************************************************
//---------------------------------------------------------------------------
	}

