/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.history;

import java.awt.Component;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.widgets.GenericRenderer;
import lu.tudor.santec.i18n.Relocalizable;

public class HistoryRenderer extends GenericRenderer implements Relocalizable
	{
/**
	 * 
	 */

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component	l_Component;
	JLabel      l_Label;
	int			l_Column;
	
	l_Label = (JLabel) super.getTableCellRendererComponent(p_Table, p_Value, 
													           p_IsSelected, p_HasFocus, 
													           p_Row, p_Column);
		
	l_Component = l_Label;
	
	if ((p_Value != null) && (l_Label != null)) 
		{
		l_Column = this.modelColumn(p_Table, p_Column);		
		
		switch (l_Column)
			{		
			case HistoryTreeTableModel.c_ExaminationDateColumn :
			
				if (p_Value instanceof Date) 
					{
					l_Label.setText (this.formatDate((Date)p_Value));
					l_Label.setHorizontalAlignment(SwingConstants.CENTER);
					}
				break;
		
			default:
		
				l_Label.setText (p_Value.toString());
				break;
			}
		}
	
	return l_Component;
	}
//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
