package lu.tudor.santec.gecamed.labo.gui.fileimport;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class ChoosePhysicianDialog extends GECAMedBaseDialog 
{
	private static final long serialVersionUID = 1L;
	
	private static Vector<Physician> physicians;
	
	private int 		buttonOption;
	private Physician 	physician;
	
	
	public ChoosePhysicianDialog(Physician physician)
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("FileImportHandler.PhysicianDoesNotExist_Title"), 
				GECAMedBaseDialog.YES_NO_CANCEL_BUTTON_MODE);
		
		// define the panel
		JPanel mainPanel = new JPanel (new FormLayout(
				"10px, f:1px:g, f:p, 10px",
				"10px, f:p:g, 5px, f:p, 10px"));
		mainPanel.setOpaque(false);
		
		CellConstraints cc = new CellConstraints();

		String firstName= physician.getFirstName();
		String surName 	= physician.getName();
		String ucm 		= physician.getUcmCode();
		
		JLabel label = new JLabel("<html>"+Translatrix.getTranslationString("FileImportHandler.PhysicianDoesNotExist_Message")
				.replace("$FIRSTNAME", 	firstName 	== null ? "" : firstName)
				.replace("$SURNAME", 	surName 	== null ? "" : surName)
				.replace("$UCMCODE", 	ucm 		== null ? "" : ucm));
		label.setOpaque(false);
		mainPanel.add(label, cc.xyw(2, 2, 2));
		
		final JComboBox box = new JComboBox(getPhysicians());
		box.setSelectedItem(MainFrame.getCurrentPhysician());
		box.setOpaque(false);
		mainPanel.add(box, cc.xy(3, 4));
		
//		box.addActionListener(new ActionListener()
//		{
//			public void actionPerformed(ActionEvent e)
//			{
//				ChoosePhysicianDialog.this.physician = (Physician) box.getSelectedItem();
//			}
//		});
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		// define the buttons
		yesButton.addActionListener(new ActionListener()
		{	
			public void actionPerformed(ActionEvent e)
			{
				buttonOption = GECAMedBaseDialog.YES_OPTION;
				ChoosePhysicianDialog.this.physician = (Physician) box.getSelectedItem();
			}
		});
		
		noButton.addActionListener(new ActionListener()
		{	
			public void actionPerformed(ActionEvent e)
			{
				buttonOption = GECAMedBaseDialog.NO_OPTION;
			}
		});
		
		cancelButton.addActionListener(new ActionListener()
		{	
			public void actionPerformed(ActionEvent e)
			{
				buttonOption = GECAMedBaseDialog.CANCEL_OPTION;
			}
		});
	}

	private Vector<Physician> getPhysicians ()
	{
//		if (physicians == null)
//		{
//			physicians = new Vector<Physician>();
//			OfficeManagerInterface manager = (OfficeManagerInterface) ManagerFactory.getRemote(OfficeManagerBean.class);
//			physicians.addAll(manager.getAllPhysicians());
//		}
//		
//		return physicians;
		return new Vector<Physician>(GECAMedLists.getListReference(Physician.class));
	}
	
	public int getButtonOption ()
	{
		return buttonOption;
	}
	
	public Physician getPhysician ()
	{
		return physician;
	}
}
