package lu.tudor.santec.gecamed.labo.gui.fileimport;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.patientlist.PatientSearchDialog;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ChoosePatientDialog.java,v $
 * <br>Revision 1.1  2013-09-04 06:24:05  ferring
 * <br>Labo module now has the option to select the patient, if he / she doesn't exist
 * <br>
 */

public class ChoosePatientDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	public static final int	CREATE_NEW_PATIENT	= 100;
	public static final int	REASSIGN_PATIENT	= 101;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static ChoosePatientDialog instance;
	
	
	private Patient patient;
	
	private JLabel	messageLabel;
	
	private JButton	searchPatientButton;
	
	private JButton	createNewPatientButton;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public ChoosePatientDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("FileImportHandler.PatientDoesNotExist.title"),
				OK_CANCEL_BUTTON_MODE);
		
		messageLabel	= new JLabel();
		messageLabel.setOpaque(false);
		mainPanel.add(messageLabel);
		
		// create the button to create a new patient to attach this result to
		createNewPatientButton	= new JButton(new AbstractAction(
				Translatrix.getTranslationString("FileImportHandler.PatientDoesNotExist.createNewPatient"),
				IconFetcher.getMediumIcon(PatientManagerModule.class, "patient_new_action.png"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				buttonOption	= CREATE_NEW_PATIENT;
				setVisible(false);
			}
		});
		addButton(createNewPatientButton);
		createNewPatientButton.setToolTipText(Translatrix.getTranslationString(
				"FileImportHandler.PatientDoesNotExist.createNewPatientTip"));
		
		// create the button to search an existing patient to attach this result to
		searchPatientButton			= new JButton(new AbstractAction(
				Translatrix.getTranslationString("FileImportHandler.PatientDoesNotExist.searchPatient"),
				IconFetcher.getMediumIcon(PatientManagerModule.class, "patientsearch.png"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				Patient	patient		= ChoosePatientDialog.this.patient;
				
				String ssn			= patient.getSocialSecurityNumber();
				String maidenName	= patient.getMaidenName();
				String surName		= patient.getSurName();
				
				
				if (maidenName == null)
					maidenName		= "";
				if (surName == null)
					surName			= "";
				if (ssn == null)
					ssn				= "";
				else if (ssn.length() > 8)
				{
					ssn				= ssn.substring(0, 8);
				}
				
				patient 			= PatientSearchDialog.searchPatient(
						new StringBuilder()
								.append(ssn)
								.append(" ")
								.append(surName)
								.append(" ")
								.append(maidenName)
								.toString()
				);
				if (patient != null)
				{
					ChoosePatientDialog.this.patient	= patient;
					buttonOption	= REASSIGN_PATIENT;
					setVisible(false);
				}
			}
		});
		searchPatientButton.setToolTipText(Translatrix.getTranslationString(
				"FileImportHandler.PatientDoesNotExist.searchPatientTip"));
		addButton(searchPatientButton);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public int showDialog (Patient patient)
	{
		String firstName 	= patient.getFirstName();
		String surName 		= patient.getSurName();
		String ssn 			= patient.getSocialSecurityNumber();
		
		
		messageLabel.setText(Translatrix.getTranslationString("FileImportHandler.PatientDoesNotExist.message", 
				new String []
				{
					(firstName != null ? firstName : ""), 
					(surName != null ? surName : ""), 
					(ssn != null ? ssn : "")
				}));
		
		this.patient	= patient;
		
		pack();
		showCenteredDialog();
		
		return buttonOption;
	}
	
	
	public static ChoosePatientDialog getInstance ()
	{
		if (instance == null)
			instance = new ChoosePatientDialog();
		
		return instance;
	}
	
	
	public Patient getPatient ()
	{
		return this.patient;
	}
}
