package lu.tudor.santec.gecamed.labo.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Collection;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class DownloadInfoDialog extends GECAMedBaseDialog
{
	private static final long serialVersionUID = 1L;
	
	
	public DownloadInfoDialog (Collection<String> importedFiles, Collection<String> notImportedFiles)
	{
		super (MainFrame.getInstance(), 
				Translatrix.getTranslationString("DownloadInfoDialog.downloadInfo"),
				GECAMedBaseDialog.OK_BUTTON_MODE);
		
		JScrollPane scroller;
		JList		list;
		JLabel		label;
		CellConstraints cc = new CellConstraints();
		
		JPanel mainPanel = new JPanel (new FormLayout(
				// columns:
				"5px, f:250px:g(0.5), 5px, f:250px:g(0.5), 5px",
				// rows:
				"5px, f:p, 5px, f:p, 2px, f:125px:g, 5px"));
		mainPanel.setOpaque(false);
		
		label = new JLabel(Translatrix.getTranslationString("DownloadInfoDialog.importedAndNotImported"));
		label.setOpaque(false);
		mainPanel.add(label, cc.xyw(2, 2, 3));
		
		label = new JLabel (Translatrix.getTranslationString("DownloadInfoDialog.imported"));
		label.setOpaque(false);
		mainPanel.add(label, cc.xy(2, 4));

		label = new JLabel (Translatrix.getTranslationString("DownloadInfoDialog.notImported"));
		label.setOpaque(false);
		mainPanel.add(label, cc.xy(4, 4));
		
		list = new JList(importedFiles.toArray());
		list.setBackground(Color.WHITE);
		scroller = new JScrollPane(list);
		scroller.getViewport().setBackground(Color.WHITE);
		mainPanel.add(scroller, cc.xy(2, 6));
		
		list = new JList(notImportedFiles.toArray());
		list.setBackground(Color.WHITE);
		scroller = new JScrollPane(list);
		scroller.getViewport().setBackground(Color.WHITE);
		mainPanel.add(scroller, cc.xy(4, 6));
		
		this.add(mainPanel, BorderLayout.CENTER);
	}
}
