/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Connection;
import lu.tudor.santec.i18n.Translatrix;

public class ConnectionListModel extends AbstractTableModel
	{
	private static final long serialVersionUID = 1L;

	private Vector <Connection> m_Connections;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	public static final String c_StatusHeader 			= "ConnectionListModel.StatusHeader";
	public static final String c_EnabledHeader 			= "ConnectionListModel.EnabledHeader";
	public static final String c_ServerHeader 			= "ConnectionListModel.ServerHeader";
 
    public static final int 	c_StatusColumn 			= 0;
    public static final int 	c_EnabledColumn 		= 1;
    public static final int 	c_ServerColumn 			= 2;
 
    public static final  String m_TableHeaders [] =  { 	c_StatusHeader,
    													c_EnabledHeader,
    												    c_ServerHeader };

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public  ConnectionListModel ()
	{
	m_Connections = new Vector <Connection> ();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < m_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(m_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (m_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Connections.size());
    }

//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
	if (p_Column == c_EnabledColumn) 
		 return true;
	else return false;
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
	{
   Connection  l_Connection = null;
     
    if ((p_Row >= 0) && (p_Row < m_Connections.size()))
        {
    	l_Connection = m_Connections.elementAt (p_Row);
        }
	
    if (l_Connection == null) return "";
    
    switch (p_Column)
        {
        case  c_StatusColumn      : return (l_Connection.getStatus() != null)?l_Connection.getStatus():Connection.c_Idle;
        case  c_EnabledColumn     : return (l_Connection.getEnabled() != null)?l_Connection.getEnabled():Boolean.FALSE;
        case  c_ServerColumn      : return (l_Connection.getServer() != null)?l_Connection.getServer():"";
      
        default: return "";
        }
 	}

//---------------------------------------------------------------------------

public void setValueAt (Object p_Value, int p_Row, int p_Column)
	{
  Connection  l_Connection = null;
     
    if ((p_Row >= 0) && (p_Row < m_Connections.size()))
        {
    	l_Connection = m_Connections.elementAt (p_Row);
        }
	
    if (l_Connection == null) return;
	
 	switch (p_Column)
		{
		case  c_EnabledColumn: l_Connection.setEnabled((Boolean)p_Value);
							   m_Connections.setElementAt(l_Connection, p_Row);
							   break;
		}
	fireTableCellUpdated (p_Row,p_Column);
	}

//---------------------------------------------------------------------------

public Connection getConnectionAt (int p_Row)
	{
	if ((p_Row >= 0) && (p_Row < this.getRowCount()))	
		 return m_Connections.elementAt(p_Row);
	else return null;
	}

//---------------------------------------------------------------------------

public void setConnectionAt (Connection p_Connection, int p_Row)
	{
	if ((p_Connection != null) && (p_Row >= 0) && (p_Row < this.getRowCount()))
		{
		m_Connections.setElementAt (p_Connection, p_Row);
		this.fireTableRowsUpdated (p_Row, p_Row);
		}
	}

//---------------------------------------------------------------------------

public void setConnections (Collection <Connection> p_Connections)
	{
	int	l_LastRow;
	
	l_LastRow = this.getRowCount() - 1;
	m_Connections.removeAllElements();	
	if (l_LastRow > 0) this.fireTableRowsDeleted (0, l_LastRow);
	
	if ((p_Connections != null) && (p_Connections.size() > 0))
		{
		m_Connections.addAll(p_Connections);	
		this.fireTableRowsInserted(0, p_Connections.size());
		}
	}

//---------------------------------------------------------------------------

public Collection <Connection> getConnections ()
	{
	Collection <Connection>	l_Connections;
		
	l_Connections = new ArrayList <Connection> (m_Connections);	
	
	return l_Connections;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
