/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.admin;

import java.util.Collection;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;

public class PhysicianListModel extends AbstractTableModel
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Vector <Physician> m_Physicians;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
    
	public static final String c_NameHeader 			= "PhysicianListModel.NameHeader";
    public static final String c_UCMCodeHeader			= "PhysicianListModel.UCMCodeHeader";

    public static final int 	c_NameColumn 			= 0;
    public static final int 	c_UCMCodeColumn			= 1;

    public static final  String m_TableHeaders [] =  { 	c_NameHeader,
    												    c_UCMCodeHeader };
   
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public PhysicianListModel ()
	{
	m_Physicians = new Vector <Physician> ();	
	}
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < m_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(m_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (m_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Physicians.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Physician  l_Physician = null;
     
    if ((p_Row >= 0) && (p_Row < m_Physicians.size()))
        {
    	l_Physician = m_Physicians.elementAt (p_Row);
        }
    
    if (l_Physician == null) return "";
    
    switch (p_Column)
        {
        case  c_NameColumn: 	 return l_Physician.toString();
        case  c_UCMCodeColumn: 	 return l_Physician.getUcmCode();
     
        default: return "";
        }
    }

//---------------------------------------------------------------------------

public Physician getPhysicianAt (int p_Row)
	{
	if ((p_Row >= 0) && (p_Row < m_Physicians.size()))
		return m_Physicians.elementAt (p_Row);
	else return null;
	}

//---------------------------------------------------------------------------

public void setPhysicians (Collection <Physician> p_Physicians)
	{
	m_Physicians.removeAllElements();
	if ((p_Physicians != null) && (p_Physicians.size() > 0))
		{
		m_Physicians.addAll(p_Physicians);	
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
