/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.admin;

import java.util.Collection;
import java.util.Date;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.PhysicianKey;
import lu.tudor.santec.i18n.Translatrix;

public class PhysicianKeyListModel extends AbstractTableModel
	{
	private static final long serialVersionUID = 1L;

	private Vector <PhysicianKey> m_Keys;
	
	public static final Date c_Epoch = new Date (0);

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	public static final String c_LabelHeaderHeader 		= "PhysicianKeyListModel.LabelHeader";
	public static final String c_ExpiryHeader 			= "PhysicianKeyListModel.ExpiryHeader";
	public static final String c_PasswordHeader 		= "PhysicianKeyListModel.PasswordHeader";
 
    public static final int 	c_LabelColumn 			= 0;
    public static final int 	c_ExpiryColumn 			= 1;
    public static final int 	c_PasswordColumn 		= 2;

    public static final  String m_TableHeaders [] =  { 	c_LabelHeaderHeader,
    												    c_ExpiryHeader,
    												    c_PasswordHeader };

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public  PhysicianKeyListModel ()
	{
	m_Keys = new Vector <PhysicianKey> ();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < m_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(m_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (m_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Keys.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
	{
   PhysicianKey  l_Key = null;
     
    if ((p_Row >= 0) && (p_Row < m_Keys.size()))
        {
    	l_Key = m_Keys.elementAt (p_Row);
        }
	
    if (l_Key == null) return "";
    
    switch (p_Column)
        {
        case  c_LabelColumn    : return (l_Key.getLabel() != null)?l_Key.getLabel():"";
        case  c_ExpiryColumn   : return (l_Key.getExpiryDate() != null)?l_Key.getExpiryDate():c_Epoch;
        case  c_PasswordColumn : return (l_Key.getPassword() != null)?Boolean.TRUE:Boolean.FALSE;
     
        default: return "";
        }
 	}

//---------------------------------------------------------------------------

public void addKey (PhysicianKey p_Key)
	{
	int	l_LastRowBefore;
	int	l_LastRowAfter;

	if (p_Key != null) 
		{
		l_LastRowBefore = this.getRowCount() -1;
		m_Keys.add(p_Key);	
		l_LastRowAfter = this.getRowCount() -1;	
		if (l_LastRowAfter > l_LastRowBefore) fireTableRowsInserted (l_LastRowBefore,l_LastRowAfter);
		}
	}

//---------------------------------------------------------------------------

public PhysicianKey getKeyAt (int p_Row)
	{
	if ((p_Row >= 0) && (p_Row < this.getRowCount()))	
		 return m_Keys.elementAt(p_Row);
	else return null;
	}

//---------------------------------------------------------------------------

public void setKeyAt (PhysicianKey p_Key, int p_Row)
	{
	if ((p_Key != null) && (p_Row >= 0) && (p_Row < this.getRowCount()))
		{
		m_Keys.setElementAt (p_Key, p_Row);
		this.fireTableRowsUpdated (p_Row, p_Row);
		}
	}

//---------------------------------------------------------------------------

public void removeKeyAt (int p_Row)
	{
	if ((p_Row >= 0) && (p_Row < this.getRowCount()))
		{
		m_Keys.remove(p_Row);
		this.fireTableRowsDeleted (p_Row, p_Row);
		}
	}

//---------------------------------------------------------------------------

public void setKeys (Collection <PhysicianKey> p_Keys)
	{
	int	l_LastRow;
	
	l_LastRow = this.getRowCount() - 1;
	m_Keys.removeAllElements();
	if (l_LastRow > 0) this.fireTableRowsDeleted (0, l_LastRow);
	
	if ((p_Keys != null) && (p_Keys.size() > 0))
		{
		m_Keys.addAll(p_Keys);	
		this.fireTableRowsInserted(0, p_Keys.size());
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
