/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Certifier;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Laboratory;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.LaboratoryCertificate;
import lu.tudor.santec.gecamed.labo.utils.LaboException;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Remote
public interface LaboratoryInterface 
	{
//***************************************************************************
//* Constants						                                        *
//***************************************************************************

	public static final int c_ContactPersonDependency 	= 1;
	public static final int c_AddressDependency 		= 2;
	public static final int c_CertificateDependency 	= 3;

//***************************************************************************
//* Interface	  					                                        *
//***************************************************************************

	public Laboratory				getLaboratoryByID 		(Integer p_Id) 							throws Exception;
	
	public Laboratory				getLaboratoryByUCMCode 	(String p_UCMCode) 						throws Exception;

	public Laboratory				fetchLazyDependency 	(Laboratory p_Laboratory, Integer p_Dependency) 				throws Exception;
	
	public Laboratory				fetchLazyDependencies 	(Laboratory p_Laboratory, Collection <Integer> p_Dependencies) 	throws Exception;
	
	public Laboratory 				saveLaboratory 			(Laboratory p_Laboratory) 				throws Exception;
	
	public void						deleteLaboratory 		(Laboratory p_Laboratory) 				throws Exception;

	public Collection <String>		getAllCertificateLabels	()										throws Exception;
		
	public LaboratoryCertificate	getCertificateByLabel 	(String	p_Label)						throws Exception;
	
	public LaboratoryCertificate	saveCertificate 		(LaboratoryCertificate p_Certificate)	throws Exception;
	
	public void						deleteCertificate		(LaboratoryCertificate p_Certificate)	throws Exception;
	
	public String					getCAChain				() throws LaboException;
	
	public Certifier				getCertifierByLabel		(String label);
	
	public Certifier				getOutdatedCertifier	(String label, Date lastModified);

	public Certifier				saveCertifier			(Certifier c);
	
	public String 					saveFailedResultImport	(byte[] fileData, String fileName, String logMessage, Throwable cause);

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}

