/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Connection;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.PhysicianKey;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Result;
import lu.tudor.santec.gecamed.labo.utils.DecryptException;
import lu.tudor.santec.gecamed.labo.utils.PasswordEncrypter;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Remote
public interface ImportInterface
	{
//***************************************************************************
//* Interface	  					                                        *
//***************************************************************************
	
	public static final int IMPORT_NOT_SUCCESSFUL	=-1;
	public static final int IMPORT_SUCCESSFUL 		= 0;
	public static final int CANCEL_IMPORTING 		= 1;
	public static final int SKIP_THIS_RESULT 		= 2;
	public static final int RESULT_ALREADY_EXISTS	= 3;
	public static final int COULD_NOT_SAVE_RESULT 	= 4;
	public static final int UNKNOWN_REASON			= 5;
	
	public static final String INVALID_XML 						= "FileImportHandler.ErrorWhileImport_InvalidXML";
	public static final String EXPIRED_SIGNATURE 				= "FileImportHandler.ErrorWhileImport_ExpiredSignature";
	public static final String INVALID_SIGNATURE 				= "FileImportHandler.ErrorWhileImport_InvalidSignature";
//	public static final String WRONG_LABO_KEY 					= "FileImportHandler.ErrorWhileImport_WrongLaboKey";
	public static final String WRONG_PHYSICIAN_KEY 				= "FileImportHandler.ErrorWhileImport_WrongPhysicianKey";
	public static final String UNABLE_TO_DECRYPT 				= "FileImportHandler.ErrorWhileImport_UnableToDecrypt";
	public static final String RESULT_NOT_ENCRYPTED 			= "FileImportHandler.ErrorWhileImport_ResultNotEncrypted";
	public static final String NO_KEY_SET						= "FileImportHandler.ErrorWhileImport_NoKeySet";
	public static final String NO_CERTIFICATE_SET				= "FileImportHandler.ErrorWhileImport_NoCertificateSet";
	public static final String UNEXPECTED_EXCEPTION				= "FileImportHandler.ErrorWhileImport_UnexpectedException";
	public static final String NO_KEYSTORE_SET					= "FileImportHandler.ErrorWhileImport_NoKeystoreSet";
	public static final String UNABLE_TO_VERIFY					= "FileImportHandler.ErrorWhileImport_UnableToVerify";
	public static final String UNABLE_TO_SETUP_KEYSTORE			= "FileImportHandler.ErrorWhileImport_UnableToSetupKeystore";
	public static final String COULD_NOT_MOVE_FILE				= "FileImportHandler.ErrorWhileImport_CouldNotMoveFile";
	public static final String COULD_NOT_ESTABLISH_CONNECTION	= "FileImportHandler.ErrorWhileImport_CouldntEstablishConnect";
	public static final String NO_MATCHING_CERTIFICATE_FOUND 	= "FileImportHandler.ErrorWhileImport_NoMatchingCertificateFound";
	public static final String FILENAME_DOESNT_MATCH_PATTERN	= "FileImportHandler.ErrorWhileImport_FileNameDoesntMatchPattern";
	
	

	public void	setPasswordEncrypter					(PasswordEncrypter p_Encrypter);
				
	public void setPhysicianKey							(PhysicianKey p_Key, String p_KeyPassword);
	
	public Boolean synchronizeCertificates 			    (Connection p_Connection) throws Exception;

	public Boolean openConnection						(Connection p_Connection) throws Exception;

	public Collection <String>	getAvailableResults		() throws Exception;
	
	public Result 	importResult						(byte[] p_EncryptedResult, String p_ResultFileName) throws Exception;
	
	public Result 	importResult						(String p_ResultFileName) throws Exception;
		
	public void	   	closeConnection						();
	
	public void		remove								();
	
	public void 	moveResultFile						(String p_ResultFileName) throws DecryptException;
	
	public Result	saveResult							(Result p_Result) throws Exception;
	
//***************************************************************************
//* End of Interface														*
//***************************************************************************
	}
