/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "masterpassword", schema = "labo")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = MasterPassword.c_PasswordByOfficeId,      query = "SELECT OBJECT(o) FROM MasterPassword o WHERE o.officeId = :"    + MasterPassword.c_OfficeIdParameter)
	})

public class MasterPassword extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private Integer	m_OfficeId;
	private String	m_PasswordHash;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;
	
	public static final transient String c_PasswordByOfficeId	    = "getPasswordByOfficeId";

	public static final transient String c_OfficeIdParameter	    = "officeId";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the medical office this master password belongs to
 * @return the Id of the medical office this master password belongs to
 */
//---------------------------------------------------------------------------

@Column(name = "office_id")
public Integer getOfficeId()
	{
	return m_OfficeId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the office this master password belongs to
 * @param p_OfficeId specifies the new Id of the owning office
 */
//---------------------------------------------------------------------------

public void setOfficeId(Integer p_OfficeId)
	{
	m_OfficeId = p_OfficeId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the password hash for this master password
 * @return the MD5 hash of the password this master password represents
 */
//---------------------------------------------------------------------------

@Column(name = "password")
public String getPasswordHash()
	{
	return m_PasswordHash;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the password hash for this master password
 * @param p_PasswordHash specifies the new password hash
 */
//---------------------------------------------------------------------------

public void setPasswordHash (String p_PasswordHash)
	{
	m_PasswordHash = p_PasswordHash;
	}


//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
