/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * @author nico.mack@tudor.lu
 * @since 08/03/17 
 */

@Entity
@Table(name = "labo_certificate", schema = "labo")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = LaboratoryCertificate.c_CertificatesByLaboratoryId,   query = "SELECT OBJECT(o) FROM LaboratoryCertificate o WHERE o.laboratoryId = :" + LaboratoryCertificate.c_LaboratoryIdParameter),
	@NamedQuery(name = LaboratoryCertificate.c_CertificateByLabel,           query = "SELECT OBJECT(o) FROM LaboratoryCertificate o WHERE o.label = :" + LaboratoryCertificate.c_LabelParameter),
	@NamedQuery(name = LaboratoryCertificate.c_AllCertificateLabels,         query = "SELECT o.label FROM LaboratoryCertificate o")	
	})

	public class LaboratoryCertificate extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	
	private static final long serialVersionUID = 1L;
	
	private Integer   m_LaboratoryId;
	String			  m_Label;
	Date			  m_ExpiryDate;			
	private Boolean	  m_Trusted;
	private byte[]	  m_PEMData;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	public static final transient String c_CertificatesByLaboratoryId   = "getCertificatesByLaboratoryId";
	public static final transient String c_AllCertificateLabels	        = "getAllCertificateLabels";
	public static final transient String c_CertificateByLabel	        = "getCertificateLabel";

	public static final transient String c_LaboratoryIdParameter	    = "laboratoryId";
	public static final transient String c_LabelParameter	   			= "label";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public LaboratoryCertificate ()
	{
	m_Trusted = Boolean.valueOf (false);	
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the laboratory this certificate is attached to
 * @return the Id of the laboratory this certificate is attached to
 */
//---------------------------------------------------------------------------

@Column(name = "laboratory_id", updatable=false, insertable=false)
public Integer getLaboratoryId()
	{
	return m_LaboratoryId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the laboratory this certificate is to be attached to
 * @param p_LaboratoryId specifies the new Id of the owning laboratory
 */
//---------------------------------------------------------------------------

public void setLaboratoryId(Integer p_LaboratoryId)
	{
	m_LaboratoryId = p_LaboratoryId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the label or filename of this certificate
 * @return This certificate's label or filename
 */
//---------------------------------------------------------------------------

@Column (name ="label")

public String getLabel() 
	{
	return m_Label;
	}

//---------------------------------------------------------------------------
/**
 * Sets the label or filename of this certificate
 * @param p_Label specifies the new label for this certificate
 */
//---------------------------------------------------------------------------

public void setLabel (String p_Label) 
	{
	m_Label = p_Label;
	}

//---------------------------------------------------------------------------
/**
 * Returns this certificate's expiry date
 * @return The date this certificate expires, i.e. the date it looses its
 * validity.
 */
//---------------------------------------------------------------------------

@Column(name = "expiry")

public Date getExpiryDate() 
	{
	return m_ExpiryDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified date as this certificate's' expiry date
 * @param p_ExpiryDate specifies the new certificate expiry date
 */
//---------------------------------------------------------------------------

public void setExpiryDate (Date p_ExpiryDate) 
	{
	m_ExpiryDate = (p_ExpiryDate != null) ? new Date (p_ExpiryDate.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * Returns the whether this certificate is trustworthy or not. Trustworthyness
 * is established by verifying the X509 certificate represented by this 
 * certificate against the root certificate.
 * @return <code>true</code> if this certificate can be trusted, i.e. was
 * successfully verified against the root certificate, <code>false</code>
 * otherwise.
 */
//---------------------------------------------------------------------------

@Column (name ="trusted")

public Boolean getTrusted() 
	{
	return m_Trusted;
	}

//---------------------------------------------------------------------------
/**
 * Sets the trustworthiness of this certificate
 * @param p_Trusted specifies whether or not this certificate can be trusted.
 * @see #getTrusted()
 */
//---------------------------------------------------------------------------

public void setTrusted (Boolean p_Trusted) 
	{
	m_Trusted = p_Trusted;
	}

//---------------------------------------------------------------------------
/**
 * Returns the PEM (Privacy Enhanced Mail) data stored for this certificate
 * @return The certificate's PEM data
 */
//---------------------------------------------------------------------------

@Column(name = "pem_data")

public byte[] getPemData () 
	{
	return m_PEMData;
	}

//---------------------------------------------------------------------------
/**
 * Sets the PEM data for this certifacte
 * @return p_PemData specifies the new PEM data for certificate
 */
//---------------------------------------------------------------------------

public void setPemData (byte[] p_PemData) 
	{
	m_PEMData = p_PemData;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
