/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/

package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "culture", schema = "labo")

public class Culture extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer	m_AntibiogramId;
	private Integer m_SequenceNumber;
	private String	m_Name;
	private String  m_Concentration;
	private String  m_Unit;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the antibiogram this culture is part of
 * @return the Id of the antibiogram this culture is part of
 */
//---------------------------------------------------------------------------

@Column(name = "antibiogram_id", updatable=false, insertable=false)
public Integer getAntibiogramId()
	{
	return m_AntibiogramId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the antibiogram this culture is to be part of
 * @param p_AntibiogramId specifies the new Id of the owning antibiogram
 */
//---------------------------------------------------------------------------

public void setAntibiogramId (Integer p_AntibiogramId)
	{
	m_AntibiogramId = p_AntibiogramId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the sequence number for this culture. The sequence number usually
 * corresponds to the column number of this culture in the antibiogram. The
 * sequence number links the culture to the corresponding reactions.
 * @return sequence number for this culture.
 */
//---------------------------------------------------------------------------

@Column (name = "culture_seq_number")
public Integer getSequenceNumber ()
	{
	return m_SequenceNumber;	
	}

//---------------------------------------------------------------------------

public void setSequenceNumber (Integer p_SequenceNumber)
	{
	m_SequenceNumber = 	p_SequenceNumber;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of this culture
 * @return the name of this culture
 */
//---------------------------------------------------------------------------

@Column(name = "name")
public String getName()
	{
	return m_Name;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the name for this culture
 * @param p_Name specifies the new name for this culture
 */
//---------------------------------------------------------------------------

public void setName (String p_Name)
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * Returns the concentration of this culture used for the test
 * @return the concentration of this culture
 */
//---------------------------------------------------------------------------

@Column(name = "concentration")
public String getConcentration()
	{
	return m_Concentration;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the concentration for this culture
 * @param p_Concentration specifies the new concentration for this culture
 */
//---------------------------------------------------------------------------

public void setConcentration (String p_Concentration)
	{
	m_Concentration = p_Concentration;
	}

//---------------------------------------------------------------------------
/**
 * Returns the unit of the concentration for this culture
 * @return the unit of this culture's concentration
 */
//---------------------------------------------------------------------------

@Column(name = "unit")
public String getUnit()
	{
	return m_Unit;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the unit of this culture's concentration
 * @param p_Unit specifies the new unit for this culture's concentration
 */
//---------------------------------------------------------------------------

public void setUnit (String p_Unit)
	{
	m_Unit = p_Unit;
	}


//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
