/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "connection", schema = "labo")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = Connection.c_AllConnections, 	   	    query = "SELECT OBJECT(o) FROM Connection o"),
	@NamedQuery(name = Connection.c_ConnectionsByPhysicianId,   query = "SELECT OBJECT(o) FROM Connection o WHERE o.physicianId = :" + Connection.c_PhysicianIdParameter),
	@NamedQuery(name = Connection.c_ConnectionsByOfficeId,      query = "SELECT OBJECT(o) FROM Connection o WHERE o.officeId = :"    + Connection.c_OfficeIdParameter),
	@NamedQuery(name = Connection.c_EnabledConnections,         query = "SELECT OBJECT(o) FROM Connection o WHERE o.enabled = true")
	})

public class Connection extends GECAMedEntityBean
	{
	private Integer		m_OfficeId;
	private Integer		m_PhysicianId;
	private String		m_Server;
	private Integer		m_Port;
	private String		m_Username;
	private String		m_Password;
	private Boolean		m_PassiveMode;
	private Boolean		m_Synchronize;
	private Boolean		m_Enabled;
	
	private transient Integer	m_Status;	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final transient int	c_Idle						= 0;
	public static final transient int	c_Connecting				= 1;
	public static final transient int	c_Connected					= 2;
	public static final transient int	c_Synchronizing				= 3;
	public static final transient int	c_Downloading				= 4;
	public static final transient int	c_Done						= 5;
	public static final transient int	c_Failed					= 6;
	
	public static final transient String c_AllConnections     	    = "getAllConnections";
	public static final transient String c_ConnectionsByPhysicianId = "getConnectionsByPhysicianId";
	public static final transient String c_ConnectionsByOfficeId    = "getConnectionsByOfficeId";
	public static final transient String c_EnabledConnections		=" getEnabledConnections";

	public static final transient String c_PhysicianIdParameter	    = "physicianId";
	public static final transient String c_OfficeIdParameter	    = "officeId";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Connection ()
	{
	m_PassiveMode = Boolean.valueOf(true);	
	m_Synchronize = Boolean.valueOf(false);	
	m_Enabled     = Boolean.valueOf(true);	
	m_Status      = Integer.valueOf(c_Idle);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the office this connection was setup for
 * @return the Id of the office this connection was setup for
 */
//---------------------------------------------------------------------------

@Column(name = "office_id")
public Integer getOfficeId()
	{
	return m_OfficeId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the office this connection was setup for
 * @param p_OfficeId specifies the new Id of the owning office
 */
//---------------------------------------------------------------------------

public void setOfficeId (Integer p_OfficeId)
	{
	m_OfficeId = p_OfficeId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the Id of the physician this connection was setup for
 * @return the Id of the physician this connection was setup for
 */
//---------------------------------------------------------------------------

@Column(name = "physician_id")
public Integer getPhysicianId()
	{
	return m_PhysicianId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the physician this connection was setup for
 * @param p_PhysicianId specifies the Id of the owning physician
 */
//---------------------------------------------------------------------------

public void setPhysicianId (Integer p_PhysicianId)
	{
	m_PhysicianId = p_PhysicianId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the DNS Name or the IP Address of the server to connect to
  * @return the DNS Name or the IP Address of the server to connect to
 */
//---------------------------------------------------------------------------

@Column(name = "server")
public String getServer()
	{
	return m_Server;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the DNS Name or the IP Address of the server to connect to
 * @param p_Server specifies the new DNS Name or the IP Address of the server
 */
//---------------------------------------------------------------------------

public void setServer (String p_Server)
	{
	m_Server = p_Server;
	}

//---------------------------------------------------------------------------
/**
 * Returns the port number specified for this connection
  * @return the port number specified for this connection
 */
//---------------------------------------------------------------------------

@Column(name = "port")
public Integer getPort()
	{
	return m_Port;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the port number for this connection
 * @param p_Port specifies the new port number for this connection
 */
//---------------------------------------------------------------------------

public void setPort (Integer p_Port)
	{
	m_Port = p_Port;
	}

//---------------------------------------------------------------------------
/**
 * Returns the Username to be used to establish this connection
  * @return the Username for this connection
 */
//---------------------------------------------------------------------------

@Column(name = "username")
public String getUsername()
	{
	return m_Username;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Username to be used to establish this connection
 * @param p_UserName specifies the new user name to be used to establish this
 * connection
 */
//---------------------------------------------------------------------------

public void setUsername (String p_Username)
	{
	m_Username = p_Username;
	}

//---------------------------------------------------------------------------
/**
 * Returns the password to be used to establish this connection
  * @return the password for this connection
 */
//---------------------------------------------------------------------------

@Column(name = "password")
public String getPassword()
	{
	return m_Password;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Password to be used to establish this connection
 * connection
 */
//---------------------------------------------------------------------------

public void setPassword (String p_Password)
	{
	m_Password = p_Password;
	}

//---------------------------------------------------------------------------
/**
 * Returns whether or not this connection should be established in passive
 * mode or not
  * @return <code>true</code> if connection should be established in passive
  * mode, <code>false</code> otherwise.
 */
//---------------------------------------------------------------------------

@Column(name = "passive")
public Boolean getPassiveMode()
	{
	return m_PassiveMode;
	}
	
//---------------------------------------------------------------------------
/**
 * Specifies whether or not this connection should be established in passive
 * mode or not.
 * @param set p_PassiveMode to <code>true</code> to open this connection
 * in passive mode. Setting p_PassiveMode to <code>false</code> will set
 * this connection to active mode. 
 */
//---------------------------------------------------------------------------

public void setPassiveMode (Boolean p_PassiveMode)
	{
	m_PassiveMode = p_PassiveMode;
	}

//---------------------------------------------------------------------------
/**
 * Returns whether or not this connection should synchronize local laboratory
 * certificate store with the one available on the server specified by this
 * connection.
  * @return <code>true</code> if connection should synchronize certificate
  * store with the one on the server, <code>false</code> otherwise.
 */
//---------------------------------------------------------------------------

@Column(name = "synchronize")
public Boolean getSynchronize()
	{
	return m_Synchronize;
	}
	
//---------------------------------------------------------------------------
/**
 * Specifies whether or not this connection should bsynchronize local laboratory
 * certificate store with the one available on the server.
 * @param set p_Synchronize to <code>true</code> to enable synchronization.
 * Setting p_PassiveMode to <code>false</code> will disable it.
 */
//---------------------------------------------------------------------------

public void setSynchronize (Boolean p_Synchronize)
	{
	m_Synchronize = p_Synchronize;
	}

//---------------------------------------------------------------------------
/**
 * Returns whether or not this connection is enabled or not.
  * @return <code>true</code> if this connection is enabled and should be
  * used, <code>false</code> otherwise.
 */
//---------------------------------------------------------------------------

@Column(name = "enabled")
public Boolean getEnabled()
	{
	return m_Enabled;
	}
	
//---------------------------------------------------------------------------
/**
 * Specifies whether or not this connection is enabled.
 * @param set p_EnableIt to <code>true</code> to enable this connection.
 * Setting p_EnableIt to <code>false</code> will disable it.
 */
//---------------------------------------------------------------------------

public void setEnabled (Boolean p_EnableIt)
	{
	m_Enabled = p_EnableIt;
	}

//---------------------------------------------------------------------------
/**
 * Returns the current status for this connection
 * @return the current status for this connection
 */
//---------------------------------------------------------------------------

@Transient
public Integer getStatus()
	{
	return m_Status;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the current status for this connection
 * @param p_Status specifies the new status for this connection
 */
//---------------------------------------------------------------------------

@Transient
public void setStatus (Integer p_Status)
	{
	m_Status = p_Status;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
