/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "antibiogram", schema = "labo")

public class Antibiogram extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer	m_ResultId;
	private String	m_Title;
	private String	m_Unit;
	private String	m_Comment;

	private Set <Antibiotic>	m_Antibiotics;
	private Set <Culture>		m_Cultures;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the result this antibiogram is part of
 * @return the Id of the result this antibiogram is part of
 */
//---------------------------------------------------------------------------

@Column(name = "result_id", updatable=false, insertable=false)
public Integer getResultId()
	{
	return m_ResultId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the result this antibiogram is to be part of
 * @param p_ResultId specifies the new Id of the owning result
 */
//---------------------------------------------------------------------------

public void setResultId(Integer p_ResultId)
	{
	m_ResultId = p_ResultId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the title of this antibiogram
 * @return the title of this antibiogram
 */
//---------------------------------------------------------------------------

@Column(name = "title")
public String getTitle()
	{
	return m_Title;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the title for this antibiogram
 * @param p_Title specifies the new title for this antibiogram
 */
//---------------------------------------------------------------------------

public void setTitle (String p_Title)
	{
	m_Title = p_Title;
	}

//---------------------------------------------------------------------------
/**
 * Returns the default unit for this antibiogram
 * @return the default unit of this antibiogram
 */
//---------------------------------------------------------------------------

@Column(name = "unit")
public String getUnit()
	{
	return m_Unit;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the default unit of for this antibiogram
 * @param p_Unit specifies the new unit for this antibiogram
 */
//---------------------------------------------------------------------------

public void setUnit (String p_Unit)
	{
	m_Unit = p_Unit;
	}

//---------------------------------------------------------------------------
/**
 * Returns eventual comment provided by the laboratory for this antibiogram
 * @return comments about this antibiogram
 */
//---------------------------------------------------------------------------

@Column(name = "comments")
public String getComment()
	{
	return m_Comment;
	}

//---------------------------------------------------------------------------
/**
 * Sets eventual comments for this antibiogram
 * @param p_Comment specifies the new comments
 */
//---------------------------------------------------------------------------

public void setComment (String p_Comment)
	{
	m_Comment = p_Comment;
	}

//---------------------------------------------------------------------------
/**
 * Returns all the antibiotics used in this antibiogram
 * Antibiotics are fetched eagerly
 * @return All the antibiotics used in this antibiogram.
  */
//---------------------------------------------------------------------------

@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
@JoinColumn(name = "antibiogram_id")
@OrderBy ("id ASC")
public Set<Antibiotic> getAntibiotics ()
	{
	return m_Antibiotics;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified set of antibiotics as the ones being used to establish
 * this antibiogram.
 * @param p_Antibiotics specifies the new set of antibiotics.
 */
//---------------------------------------------------------------------------

public void setAntibiotics (Set<Antibiotic> p_Antibiotics )
	{
	m_Antibiotics = p_Antibiotics;
	}

//---------------------------------------------------------------------------
/**
 * Returns the cultures that this antibiogram was peformed on
 * Cultures are fetched eagerly
 * @return All the cultures used in this antibiogram.
  */
//---------------------------------------------------------------------------

@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
@JoinColumn(name = "antibiogram_id")
@OrderBy("sequenceNumber ASC")
public Set<Culture> getCultures ()
	{
	return m_Cultures;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified set of cultures as the ones being used to perform
 * this antibiogram.
 * @param p_Cultures specifies the new set of cultures.
 */
//---------------------------------------------------------------------------

public void setCultures (Set<Culture> p_Cultures )
	{
	m_Cultures = p_Cultures;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
