/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "analysis", schema = "labo")

public class Analysis extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	
	private Integer		m_ResultId;
	private String		m_Title;
	private String		m_SubTitle;
	private String		m_InternalCode;
	private String		m_LoincCode;
	private String		m_InternalLabel;
	private String		m_LoincLabel;
	private String		m_Value;
	private String		m_Unit;
	private String		m_ReferenceValue;
	private String		m_PreviousValue;
	private Date		m_PreviousDate;
	private Character	m_Alarm;
	private String		m_Comment;
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;

	public static final int	c_NoAlarm		= 0;
	public static final int c_Over			= 1;
	public static final int c_Under			= 2;
	public static final int c_Pathological	= 3;
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the result this test is part of
 * @return the Id of the result this test is part of
 */
//---------------------------------------------------------------------------

@Column(name = "result_id", updatable=false, insertable=false)
public Integer getResultId()
	{
	return m_ResultId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the result this test is to be part of
 * @param p_ResultId specifies the new Id of the owning result
 */
//---------------------------------------------------------------------------

public void setResultId(Integer p_ResultId)
	{
	m_ResultId = p_ResultId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the title of this test
 * @return the title of this test
 */
//---------------------------------------------------------------------------

@Column(name = "title")
public String getTitle()
	{
	return m_Title;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the title for this test
 * @param p_Title specifies the new title for this test
 */
//---------------------------------------------------------------------------

public void setTitle (String p_Title)
	{
	m_Title = p_Title;
	}

//---------------------------------------------------------------------------
/**
 * Returns the sub title of this test
 * @return the sub title of this test
 */
//---------------------------------------------------------------------------

@Column(name = "sub_title")
public String getSubTitle()
	{
	return m_SubTitle;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the sub title for this test
 * @param p_SubTitle specifies the new sub title for this test
 */
//---------------------------------------------------------------------------

public void setSubTitle (String p_SubTitle)
	{
	m_SubTitle = p_SubTitle;
	}

//---------------------------------------------------------------------------
/**
 * Returns the internal code for this test. Internal codes are codes defined
 * by the laboratory to identify this type of test. Internal codes can not
 * be used to match tests between different laboratories.
 * @return the internal code for this test.
 */
//---------------------------------------------------------------------------

@Column(name = "code_internal")
public String getInternalCode()
	{
	return m_InternalCode;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the internal code for this test.
 * @param p_InternalCode specifies the new internal code for this test
 * @see #getInternalCode()
 */
//---------------------------------------------------------------------------

public void setInternalCode (String p_InternalCode)
	{
	m_InternalCode = p_InternalCode;
	}

//---------------------------------------------------------------------------
/**
 * Returns the LOINC (Logical Observation Identifiers Names and Codes) code 
 * for this test. LOINC codes facilitate the exchange and pooling of results.
 * LOINC codes are maintained by the Regenstrief Institute (www.regenstrief.org)
 * @return the LOINC code for this test.
 */
//---------------------------------------------------------------------------

@Column(name = "code_loinc")
public String getLoincCode()
	{
	return m_LoincCode;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the LOINC code for this test.
 * @param p_LoincCode specifies the new LOINC code for this test
 * @see #getLoincCode()
 */
//---------------------------------------------------------------------------

public void setLoincCode (String p_LoincCode)
	{
	m_LoincCode = p_LoincCode;
	}

//---------------------------------------------------------------------------
/**
 * Returns the internal label for this test. Internal labels are lables defined
 * by the laboratory to identify this type of test. 
 * @return the internal label for this test.
 */
//---------------------------------------------------------------------------

@Column(name = "label_internal")
public String getInternalLabel()
	{
	return m_InternalLabel;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the internal label for this test.
 * @param p_InternalLabel specifies the new internal label for this test
 * @see #getInternalLabel()
 */
//---------------------------------------------------------------------------

public void setInternalLabel (String p_InternalLabel)
	{
	m_InternalLabel = p_InternalLabel;
	}

//---------------------------------------------------------------------------
/**
 * Returns the LOINC (Logical Observation Identifiers Names and Codes) label for 
 * this test. LOINC labels are the textual description of the corresponding
 * LOINC code. 
 * @return the LOINC label defined for this test.
 * @see #getLoincCode()
 */
//---------------------------------------------------------------------------

@Column(name = "label_loinc")
public String getLoincLabel()
	{
	return m_LoincLabel;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the LOINC label for this test.
 * @param p_LoincLabel specifies the new LOINC label for this test
 * @see #getLoincLabel()
 */
//---------------------------------------------------------------------------

public void setLoincLabel (String p_LoincLabel)
	{
	m_LoincLabel = p_LoincLabel;
	}

//---------------------------------------------------------------------------
/**
 * Returns the value of this test
 * @return the value of this test
 */
//---------------------------------------------------------------------------

@Column(name = "value")
public String getValue()
	{
	return m_Value;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the value for this test
 * @param p_Value specifies the new value for this test
 */
//---------------------------------------------------------------------------

public void setValue (String p_Value)
	{
	m_Value = p_Value;
	}

//---------------------------------------------------------------------------
/**
 * Returns the unit of the value for this test
 * @return the unit of this test's value
 */
//---------------------------------------------------------------------------

@Column(name = "unit")
public String getUnit()
	{
	return m_Unit;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the unit of this test's value
 * @param p_Unit specifies the new unit for this test's value
 */
//---------------------------------------------------------------------------

public void setUnit (String p_Unit)
	{
	m_Unit = p_Unit;
	}

//---------------------------------------------------------------------------
/**
 * Returns the reference value defined for this test
 * @return the reference value defined for this test
 */
//---------------------------------------------------------------------------

@Column(name = "reference_value")
public String getReferenceValue()
	{
	return m_ReferenceValue;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the reference value for this test
 * @param p_ReferenceValue specifies the new reference value for this test
 */
//---------------------------------------------------------------------------

public void setReferenceValue (String p_ReferenceValue)
	{
	m_ReferenceValue = p_ReferenceValue;
	}

//---------------------------------------------------------------------------
/**
 * Returns the value this analysis had in the previous examination in the same
 * laboratory. Previous value is a legacy from paper based laboratory data
 * exchange.  
 * @return the previous value of this analysis
 */
//---------------------------------------------------------------------------

@Column(name = "previous_value")
public String getPreviousValue()
	{
	return m_PreviousValue;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the previous value for this analysis
 * @param p_PreviousValue specifies the previous value for this analysis
 * @see #getPreviousValue()
 */
//---------------------------------------------------------------------------

public void setPreviousValue (String p_PreviousValue)
	{
	m_PreviousValue = p_PreviousValue;
	}

//---------------------------------------------------------------------------
/**
 * Returns the date of the analysis the previous value is taken from
 * @return the date of origin for the previous value
 */
//---------------------------------------------------------------------------

@Column(name = "previous_date")
public Date getPreviousDate()
	{
	return m_PreviousDate;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the date of the analysis the previous value is taken from
 * @param p_PreviousDate specifies the date of the analysis the previous value 
 * is taken from
 * @see #getPreviousDate()
 */
//---------------------------------------------------------------------------

public void setPreviousDate (Date p_PreviousDate)
	{
	m_PreviousDate = (p_PreviousDate != null) ? new Date (p_PreviousDate.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * Returns the state of the alarm indicator.
 * @return the state of the alarm indicator. Possible values are:
  */
//---------------------------------------------------------------------------

@Column(name = "alarm")
public Character getAlarm()
	{
	return m_Alarm;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the state of the alarm indicator for this analysis
 * @param p_Alarm specifies the new value for the alarm indicator
 */
//---------------------------------------------------------------------------

public void setAlarm (Character p_Alarm)
	{
	m_Alarm = p_Alarm;
	}

//---------------------------------------------------------------------------
/**
 * Returns the comment form the laboratory for this analysis
 * @return comment about this analysis
 */
//---------------------------------------------------------------------------

@Column(name = "comment")
public String getComment()
	{
	return m_Comment;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the comment for this analysis
 * @param p_Comment specifies the new comment for this analysis
 */
//---------------------------------------------------------------------------

public void setComment (String p_Comment)
	{
	m_Comment = p_Comment;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
