package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.util.HashMap;
import java.util.Map;

/**
 * This class represents a payment method or a bank account from an XML file
 * 
 * @author Matthias Kutscheid
 * 
 */
public class PaymentMethod {

	/**
	 * The string value, either the name of the payment method or the IBAN of a
	 * bank account
	 */
	private final String value;
	/** A flag to determine if this is a bank account */
	private final boolean isBankAccount;
	/** A cache for all PaymentMethods that are bank accounts */
	private static final Map<String, PaymentMethod> IBAN_CACHE = new HashMap<String, PaymentMethod>();
	/** A cache for all PaymentMethods that are simple payment methods */
	private static final Map<String, PaymentMethod> PAYMENT_CACHE = new HashMap<String, PaymentMethod>();

	/**
	 * Get a PaymentMethod from the cache or initialize a new one. In either
	 * case the same combination of value and isBankAccount will always result
	 * in the same object being returned
	 * 
	 * @param value The String value or IBAN of the PaymentMethod
	 * @param isBankAccount True if this PaymentMethod should represent a bank account
	 * @return
	 */
	public static PaymentMethod getPaymentMethod(String value, boolean isBankAccount) {
		PaymentMethod method = null;
		if (isBankAccount) {
			method = IBAN_CACHE.get(value);
			if (method == null) {
				method = new PaymentMethod(value, isBankAccount);
				IBAN_CACHE.put(value, method);
			}
		} else {
			method = PAYMENT_CACHE.get(value);
			if (method == null) {
				method = new PaymentMethod(value, isBankAccount);
				PAYMENT_CACHE.put(value, method);
			}
		}
		return method;
	}

	private PaymentMethod(String value, boolean isIBAN) {
		this.value = value;
		this.isBankAccount = isIBAN;
	}

	public String getValue() {
		return value;
	}

	public boolean isBankAccount() {
		return isBankAccount;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return value;
	}
}
