/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.util.List;

import javax.swing.table.DefaultTableModel;

import lu.tudor.santec.gecamed.importexport.gui.importer.ImportControler.FileStatus;
import lu.tudor.santec.gecamed.importexport.gui.importer.ImportControler.Status;
import lu.tudor.santec.i18n.Translatrix;

public class ImportTableModel extends DefaultTableModel{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	private List<FileStatus> data = null;
	
	
	public ImportTableModel() {
		/* ================================================== */
		super(new String[] {Translatrix.getTranslationString("import.table.firstCol"), Translatrix.getTranslationString("import.table.secondCol"), Translatrix.getTranslationString("import.table.thirdCol")}, 2);
		/* ================================================== */
	}
	
	
	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getColumnCount()
	 */
	@Override
	public int getColumnCount() {
		/* ====================================================== */
		// check if a patient already exists in the database
		// if sow, we need 3 columns
		/* ------------------------------------------------------- */
		if (data != null)
			for (FileStatus s : data)
				if (s.getStatus() == Status.EXISTS) {
					return 3;
				}
		return 2;
		/* ====================================================== */
	}


	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getRowCount()
	 */
	@Override
	public int getRowCount() {
		/* ====================================================== */
		if (this.data == null)
			return 0;
		return data.size();
		/* ====================================================== */
	}


	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getValueAt(int, int)
	 */
	@Override
	public Object getValueAt(int row, int column) {
		/* ====================================================== */
		if (row < 0 || row > data.size())
			return null;
		/* ------------------------------------------------------- */
		FileStatus status = data.get(row);
		if (column == 0)
			return status.isSelected4Import();
		if (column == 1)
			return status;
		if (column == 2)
			return status.getForceImport();
		return null;
		/* ====================================================== */
	}
	
	/**
	 * @param row
	 * @return
	 */
	public FileStatus getDataRow(int row) {
		/* ================================================== */
		return this.data.get(row);
		/* ================================================== */
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#isCellEditable(int, int)
	 */
	@Override
	public boolean isCellEditable(int row, int column) {
		/* ====================================================== */
		if (column == 0 ) {
			/* ------------------------------------------------------- */
			if (row > -1 && row < data.size()) {
				FileStatus s = data.get(row);
				if (s.getStatus() == Status.IMPORTED || s.getStatus() == Status.IMPORT_ERROR || s.getStatus() == Status.INVALIDE || s.getStatus() == Status.PARSE_ERROR)
					return false;
				else
					return true;
			}
			/* ------------------------------------------------------- */
		}
			
		if (column == 2)
			return data.get(row).getStatus() == Status.EXISTS;
		return false;
		/* ====================================================== */
	}


	/**
	 * @return the data
	 */
	public synchronized List<FileStatus> getData() {
		/* ================================================== */
		return data;
		/* ================================================== */
	}


	/**
	 * @param data the data to set
	 */
	public synchronized void setData(List<FileStatus> data) {
		/* ================================================== */
		this.data = data;
		/* ================================================== */
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
	 */
//	@Override
//	public Class<?> getColumnClass(int column) {
//		/* ====================================================== */
//		if (column == 0 || column == 2)
//			return Boolean.class;
//		return super.getColumnClass(column);
//		/* ====================================================== */
//	}


	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#setValueAt(java.lang.Object, int, int)
	 */
	@Override
	public void setValueAt(Object value, int row, int column) {
		/* ====================================================== */
		if (value instanceof Boolean && column == 0) {
			if (row > -1 && row < data.size())
				data.get(row).setSelected4Import((Boolean) value);
		}
		if (value instanceof Boolean && column == 2)
			if (row > -1 && row < data.size())
				data.get(row).setForceImport((Boolean) value);
		/* ====================================================== */
	}
	
	
	
}
