/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.core.gui.widgets.animatedicon.AnimatedIcon;
import lu.tudor.santec.gecamed.importexport.gui.ImporterClass;
import lu.tudor.santec.gecamed.importexport.gui.importer.ImportControler.FileStatus;
import lu.tudor.santec.gecamed.importexport.gui.importer.ImportControler.Status;

/**
 * @author martin.heinemann@tudor.lu
 * 16.07.2008
 * 11:06:09
 *
 *
 * @version
 * <br>$Log: ImportTableCellRenderer.java,v $
 * <br>Revision 1.8  2013-02-14 09:54:54  kutscheid
 * <br>first commit of the new/remodelled importer implementation
 * <br>fix some nullpointer exceptions
 * <br>
 * <br>Revision 1.7  2008-10-08 09:37:26  heinemann
 * <br>fixed icons
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-08-19 10:25:08  heinemann
 * <br>cleanup
 * <br>
 * <br>Revision 1.4  2008-07-25 14:42:42  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-07-23 09:44:53  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-07-18 14:33:06  hermen
 * <br>fixed rendering bug
 * <br>
 * <br>Revision 1.1  2008-07-18 13:44:32  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class ImportTableCellRenderer extends LineColorCellRenderer{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private JCheckBox box = new JCheckBox();
	private JLabel textLabel = new JLabel(); 
	
	private static ImageIcon okIcon       = GECAMedModule.getSmallIcon(GECAMedIconNames.OK);
//	private static ImageIcon invalideIcon = IconFetcher.getMediumIcon(ImporterClass.class, ImporterClass.INVALIDE);
	private static ImageIcon invalideIcon = GECAMedModule.getSmallIcon(GECAMedIconNames.CLOSE);
	private static ImageIcon existIcon    = GECAMedModule.getSmallIcon(GECAMedIconNames.WARNING);
	
	private static AnimatedIcon busyIcon  = new AnimatedIcon(IconFetcher.getIcon(ImporterClass.class, ImporterClass.BUSY_WHEEL_TINY));
	
	private static final Color yellowUnselected = new Color(255, 240, 51);
	private static final Color yellowSelected   = new Color(209, 196, 42);
	
	
	/**
	 * 
	 */
	public ImportTableCellRenderer() {
		/* ================================================== */
		textLabel.setOpaque(true);
		/* ================================================== */
	}

	
	/**
	 * get the background color
	 * 
	 * @param isSelected
	 * @param state
	 * @return
	 */
	private static Color getColor(boolean isSelected, Status state) {
		/* ================================================== */
		if (state == Status.INVALIDE || state == Status.PARSE_ERROR) {
			/* ------------------------------------------------------- */
			if (isSelected)
				return GECAMedColors.c_RedEvenLineSearchBackground;
			else
				return GECAMedColors.c_RedEvenLineBackground;
			/* ------------------------------------------------------- */
		} else
			if (state == Status.EXISTS) {
				/* ------------------------------------------------------- */
				if (isSelected)
					return yellowSelected;
				else
					return yellowUnselected;
				/* ------------------------------------------------------- */
			} else
				if (state == Status.WORKING) {
					/* ------------------------------------------------------- */
					if (isSelected)
						return yellowSelected;
					else
						return yellowUnselected;
					/* ------------------------------------------------------- */
				} else {
					/* ------------------------------------------------------- */
					if (isSelected)
						return GECAMedColors.c_GreenOddLineBackground;
					else
						return GECAMedColors.c_GreenEvenLineBackground;
					/* ------------------------------------------------------- */
				}
		
		/* ================================================== */
	}
	
	/**
	 * get the icon for the state
	 * 
	 * @param state
	 * @return
	 */
	private static Icon getStateIcon(Status state) {
		/* ================================================== */
		if (state == Status.INVALIDE || state == Status.PARSE_ERROR) {
			return invalideIcon;
		} else
			if (state == Status.EXISTS) 
				return existIcon;
			else
				if (state == Status.WORKING) 
					return busyIcon;
				else
					if (state == Status.IMPORTED)
						return okIcon;
					else if (state == Status.IMPORT_ERROR)
						return invalideIcon;
						else
							return null;
		/* ================================================== */
	}
		
		

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		/* ====================================================== */
//		Component renderObject = null;
		
		FileStatus fileObject = ((ImportTableModel) table.getModel()).getDataRow(row);
		if (value instanceof Boolean) {
			/* ------------------------------------------------------- */
//			renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
			box.setSelected((Boolean) value);
			box.setBackground(getColor(isSelected, fileObject.getStatus()));
			box.setHorizontalAlignment(SwingConstants.CENTER);
			
////			renderObject.setSelected((Boolean) value);
//			renderObject.setBackground(getColor(isSelected, fileObject.getStatus()));
////			renderObject.setHorizontalAlignment(SwingConstants.CENTER);
//			return renderObject;
			return box;
			/* ------------------------------------------------------- */
		}
		
		
		if (value instanceof FileStatus) {
			/* ------------------------------------------------------- */
			super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
			FileStatus status = (FileStatus) value;
			/* ------------------------------------------------------- */
			// set the icon
			/* ------------------------------------------------------- */
			textLabel.setIcon(		 getStateIcon(status.getStatus()));
			textLabel.setBackground( getColor(isSelected, status.getStatus()));
			/* ------------------------------------------------------- */
			// generate the name
			/* ------------------------------------------------------- */
			String info = status.getInfo();
			String text = "";
			if (info == null || "".equals(info.trim())) {
				text = status.getFile().getName();
			} else {
				if(isSelected) {
					text = "<html>" + info + " <span style=\"color:#808080\">defined in " + status.getFile().getName() + "</span></html>";
				} else {
					text = info;
				}
			}
			/* ------------------------------------------------------- */
			textLabel.setText(text);
			
//			textLabel.setSize(table.getColumnModel().getColumn(column).getWidth(),
//					135);
//			table.setRowHeight(row, 25);
			if (table.getRowHeight(row) != 25) {
				table.setRowHeight(row, 25);
			}
			
			return textLabel;
			/* ------------------------------------------------------- */
		}
		return super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		/* ====================================================== */
	}

	
	
	
	
	
}
