/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.awt.BorderLayout;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author martin.heinemann@tudor.lu
 * 15.07.2008
 * 13:49:33
 *
 *
 * @version
 * <br>$Log: ImportManagementPanel.java,v $
 * <br>Revision 1.4  2013-12-27 18:08:07  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2010-03-12 15:03:43  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-18 13:44:32  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class ImportManagementPanel extends GECAMedTab{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private boolean notBuild = true;

	private ImportPanel importPanel;

	private ImportControler controler;
	
	
	public ImportManagementPanel() {
		/* ================================================== */
		this.setOpaque(false);
		Translatrix.addBundle("lu.tudor.santec.gecamed.importexport.gui.resources.Translatrix");
		this.setTitle(Translatrix.getTranslationString("import.tab"));
		this.setIcon(IconFetcher.getMediumIcon(GECAMedModule.class, GECAMedIconNames.IMPORT));

		if (notBuild) {
			buildPanel();
			notBuild = false;
		}
		
		/* ================================================== */
	}


	private void buildPanel() {
		/* ====================================================== */
		this.setLayout(new BorderLayout());
		this.importPanel = new ImportPanel();
		
		this.controler = new ImportControler();
		this.controler.setPanel(importPanel);
		
		this.add(importPanel);
		
		importPanel.enableBottom(false);
		/* ====================================================== */
	}
	

}
