package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.util.List;

import javax.swing.JComboBox;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.gui.admin.AccountEditorDialog;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;

public class EnhancedAccountEditorDialog extends AccountEditorDialog {

	private static final long	serialVersionUID	= 1L;
	private final List<Physician> physicianList = GECAMedLists.getListReference(Physician.class);
	private static final Physician OFFICE_DUMMY = new Physician("Office");
	private JComboBox physicianSelection;
	
	/**
	 * An enhanced version of the AccountEditorDialog that allows to also set the owner of a new bank account
	 */
	public EnhancedAccountEditorDialog() {
		super();
		//add an office entry to the list
		physicianList.add(OFFICE_DUMMY);
		physicianSelection = new JComboBox(physicianList.toArray());
		mainPanel.add(new NamedComponent(
				Translatrix.getTranslationString("EnhancedAccountPanel.physicianName"),
				physicianSelection
				));
	}
	
	@Override
	public boolean editSettlement(Settlement settlement) {
		if(super.editSettlement(settlement) && physicianList.size() > 0) {
			Physician selectedItem = (Physician)physicianSelection.getSelectedItem();
			if(selectedItem != OFFICE_DUMMY) {
				settlement.getTransferAccount().setHolder(selectedItem);
			} else {
				settlement.getTransferAccount().setHolder(null);
			}
			return true;
		}
		return false;
	}
}
