
CREATE SCHEMA hl7interface;

CREATE TABLE  hl7interface.IMPORT_ADT (
    MessageReceptionId  bigint,
    MessageType       	varchar,
    TriggerEvent      	varchar,
    MessageDate			timestamp,
    SendingApplication	varchar,
    SendingFacility		varchar,
    ControlId			varchar,
    InternalPatientId	varchar,
    PatGivenName		varchar,
    PatFamilyName		varchar,
    PatTitle			varchar,
    PatBirthDate		timestamp,
    PatSex				varchar,
    PatMaidenName		varchar,
    PatMaritalStatus	varchar,
    PatSSN				varchar,
    PatBirthPlace		varchar,
    PatClass			varchar,
    PointOfCare			varchar,
    PatBed				varchar,
    AdmissionType		varchar,
    AttDoctorId			varchar,
    AttDoctorName		varchar,
    RefDoctorId			varchar,
    RefDoctorName		varchar,
    HospitalService		varchar,
    PatHospitalClass	varchar,
    VisitId				bigint,
    PatTransferDate		timestamp,
    AdmitTime			timestamp,
    DischargeTime		timestamp,
    AdmitReason			varchar,
    AccidentDate		timestamp,
    AccidentNumber		varchar,
    DischargeReason		varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_ADDRESS (
    MessageReceptionId  bigint,
    InternalPatientId	varchar,
    Street				varchar,
    City				varchar,
    ZipCode				varchar,
    Country				varchar,
    Type				varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_PHONE(
    MessageReceptionId  bigint,
    InternalPatientId	varchar,
    PhonePrivate		varchar,
    PhoneOffice			varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_INSURANCE(
    MessageReceptionId  bigint,
    InternalPatientId	varchar,
    InsPlanId			varchar,
    InsCompanyId		varchar,
    InsCompanyName		varchar,
    InsPolicyNumber		varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_GUARANTOR (
    MessageReceptionId  bigint,
    InternalPatientId	varchar,
    SSN					varchar,
    GivenName			varchar,
    Name				varchar,
    Street				varchar,
    ZipCode				varchar,
    City				varchar,
    Country				varchar,
    Phone				varchar,
    BirthDate			timestamp,
	GuarantorFlag		bigint,
	Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_ORU (
    MessageReceptionId  bigint,
    MessageType       	varchar,
    TriggerEvent      	varchar,
    MessageDate			timestamp,
    SendingApplication	varchar,
    SendingFacility		varchar,
    ControlId			varchar,
    InternalPatientId	varchar,
    PatGivenName		varchar,
    PatFamilyName		varchar,
    PatBirthDate		timestamp,
    PatSex				varchar,
    PatMaidenName		varchar,
    PatMaritalStatus	varchar,
    PatAccountNumber	varchar,
    PatBirthPlace		varchar,
    PatClass			varchar,
    VisitId				bigint,
    Quarantined			BOOLEAN DEFAULT FALSE,

    CONSTRAINT ORU_PK PRIMARY KEY(MessageReceptionId),
    UNIQUE (SendingFacility, SendingApplication, ControlId)
) with oids;


CREATE TABLE  hl7interface.IMPORT_REPORT (
    MessageReceptionId  bigint,
    OrderControlCode	varchar,
    PlacerOrderNumber	varchar,
    FillerOrderNumber	varchar,
    OrderStatusId		varchar,
    ServiceStart		timestamp,
    TreatmentId			varchar,
    TreatmentName		varchar,
    RequestedDate		timestamp,
    ObservationDate		timestamp,
    OrdPhysicianId		varchar,
    OrdPhysicianName	varchar,
    ResultsRepDate		timestamp,
    DiagServiceId		varchar,
    ResultStatus		varchar,
    PatTransportMode	varchar,
    ResultResponsible	varchar,
    TechnicianName		varchar,
    ExaminationEnd		timestamp,
    ReportGenDate		timestamp,
    TreatmentAltId		varchar,
    ReportData			bytea,
    ObsResultStatus		varchar,
    ProdServiceId		varchar,
    TreatUCMCode		varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_ORM (
    MessageReceptionId  bigint,
    MessageType       	varchar,
    TriggerEvent      	varchar,
    MessageDate			timestamp,
    SendingApplication	varchar,
    SendingFacility		varchar,
    ControlId			varchar,
    InternalPatientId	varchar,
    PatGivenName		varchar,
    PatFamilyName		varchar,
    PatSSN				varchar,
    PatClass			varchar,
    RadiologistId		varchar,
    RadiologistName		varchar,
    RefPhysicianId		varchar,
    RefPhysicianName	varchar,
    VisitId				bigint,
    OrderControlCode	varchar,
    PlacerOrderNumber	varchar,
    FillerOrderNumber	varchar,
    OrderStatus			varchar,
    Quantity			decimal,
    ServiceStart		timestamp,
    ServiceEnd			timestamp,
    PointOfCare			varchar,
    Room				varchar,
    Bed					varchar,
    Quarantined			BOOLEAN DEFAULT FALSE,

    CONSTRAINT ORM_PK PRIMARY KEY(MessageReceptionId),
    UNIQUE (SendingFacility, SendingApplication, ControlId)
) with oids;


CREATE TABLE  hl7interface.IMPORT_ORDER (
    MessageReceptionId  bigint,
    TreatmentName		varchar,
    TreatmentUCMCode	varchar,
    ObservationDate		timestamp,
	AccessionNumber		varchar,
    ResultInterpreter	varchar,
    TechnicianName		varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;


CREATE TABLE  hl7interface.IMPORT_PRESCRIPTION (
    MessageReceptionId  bigint,
    PrescriptionScan	bytea,
    ScanNumber			varchar,
    PageNumber			integer,
    ContentType			varchar,
    Quarantined			BOOLEAN DEFAULT FALSE

) with oids;
