/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.schedulable;

import java.util.Date;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

import org.jboss.varia.scheduler.Schedulable;

public class DailyMessagePoster implements Schedulable
{
	private String m_DailyMessage;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public DailyMessagePoster (String p_Message)
	{
	m_DailyMessage = p_Message;
	}
	
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
public void perform(Date arg0, long arg1) 
	{
	Queue 					l_Queue		 = null;
	QueueConnectionFactory 	l_Factory	 = null;
	QueueConnection			l_Connection = null;
	QueueSession			l_Session	 = null;
	QueueSender				l_Sender	 = null;
		
	try {
		InitialContext l_Context = new InitialContext();
		l_Queue = (Queue) l_Context.lookup("queue/gecamed");
		l_Factory = (QueueConnectionFactory) l_Context.lookup("ConnectionFactory");
		l_Connection = l_Factory.createQueueConnection();
		l_Session = l_Connection.createQueueSession(false,QueueSession.AUTO_ACKNOWLEDGE);
		} 
	catch (Exception e) 
		{
		e.printStackTrace ();
		}

	if (l_Session == null) return;
	
	try	{
		TextMessage msg = l_Session.createTextMessage(m_DailyMessage);
		l_Sender = l_Session.createSender(l_Queue);
		l_Sender.send(msg,DeliveryMode.NON_PERSISTENT,0,1000000);
		l_Sender.close();
		l_Session.close();
		l_Connection.close();
		}
	catch (JMSException p_Exception)
		{
		p_Exception.printStackTrace();
		}		
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************

}
