/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_report", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Reports", 				query = "SELECT OBJECT(o) FROM HL7Report o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7ReportsByMessageId", 		query = "SELECT OBJECT(o) FROM HL7Report o WHERE o.messageId = :messageid AND o.quarantined = false ORDER BY o.passageDate DESC")
//	@NamedQuery(name = "deleteHL7ReportsByMessageId",  	query = "DELETE FROM HL7Report o WHERE o.messageId = :messageid")
	})

public class HL7Report extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	
	private String	  			m_OrderControlCode;			
	private String				m_PlacerOrderNumber;
	private String				m_FillerOrderNumber;
	private String				m_OrderStatus;
	private Date				m_TransactionDate;
	
	private String				m_TreatmentId;
	private String				m_TreatmentName;
	private Date				m_RequestedDate;
	private Date				m_PassageDate;
	private String				m_OrderingPhysicianId;
	private String				m_OrderingPhysicianName;
	
	private Date				m_ResultsReportedDate;
	private String				m_DiagnosticServiceId;
	private String				m_ResultStatus;
	private String				m_TransportationMode;
	private String				m_Interpreter;
	private String				m_Technician;
	private Date				m_ExaminationEnd;
	private Date				m_ReportGenerationDate;
	
	private String				m_ExaminationAlternateId;
	private byte[]				m_Report;
	private String				m_ProducerId;
	private String				m_ExaminationStatus;
	private String				m_ExaminationCode;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	//======================================================================
	//= Possible Order Control Code
	//======================================================================
	
	public static final String	c_ORCCombinedResult			= "CN";
	public static final String	c_ORCObservationsToFollow	= "RE";
	
	public static final String	c_ORCOrderCompleted			= "CM";
	public static final String	c_ORCOrderInProcess			= "IP";
	
	public static final String c_Cart						= "CART";
	public static final String c_Port						= "PORT";
	public static final String c_Walk						= "WALK";
	public static final String c_WheelChair					= "WHLC";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "ordercontrolcode")

public String getOrderControlCode() 
	{
	return m_OrderControlCode;
	}

//---------------------------------------------------------------------------

public void setOrderControlCode (String p_OrderControlCode) 
	{
	m_OrderControlCode = p_OrderControlCode;
	}

//---------------------------------------------------------------------------

@Column(name = "placerordernumber")

public String getPlacerOrderNumber() 
	{
	return m_PlacerOrderNumber;
	}

//---------------------------------------------------------------------------

public void setPlacerOrderNumber (String p_PlacerOrderNumber) 
	{
	m_PlacerOrderNumber = p_PlacerOrderNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "fillerordernumber")

public String getFillerOrderNumber() 
	{
	return m_FillerOrderNumber;
	}

//---------------------------------------------------------------------------

public void setFillerOrderNumber (String p_FillerOrderNumber) 
	{
	m_FillerOrderNumber = p_FillerOrderNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "orderstatusid")

public String getOrderStatus() 
	{
	return m_OrderStatus;
	}

//---------------------------------------------------------------------------

public void setOrderStatus (String p_OrderStatus) 
	{
	m_OrderStatus = p_OrderStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "servicestart")

public Date getTransactionDate() 
	{
	return m_TransactionDate;
	}

//---------------------------------------------------------------------------

public void setTransactionDate (Date p_TransactionDate) 
	{
	m_TransactionDate = p_TransactionDate;
	}

//---------------------------------------------------------------------------

@Column(name = "treatmentid")

public String getTreatmentId() 
	{
	return m_TreatmentId;
	}

//---------------------------------------------------------------------------

public void setTreatmentId (String p_TreatmentId) 
	{
	m_TreatmentId = p_TreatmentId;
	}

//---------------------------------------------------------------------------

@Column(name = "treatmentname")

public String getTreatmentName() 
	{
	return m_TreatmentName;
	}

//---------------------------------------------------------------------------

public void setTreatmentName (String p_TreatmentName) 
	{
	m_TreatmentName = p_TreatmentName;
	}

//---------------------------------------------------------------------------

@Column(name = "requesteddate")

public Date getRequestedDate() 
	{
	return m_RequestedDate;
	}

//---------------------------------------------------------------------------

public void setRequestedDate (Date p_RequestedDate) 
	{
	m_RequestedDate = p_RequestedDate;
	}

//---------------------------------------------------------------------------

@Column(name = "observationdate")

public Date getPassageDate() 
	{
	return m_PassageDate;
	}

//---------------------------------------------------------------------------

public void setPassageDate (Date p_PassageDate) 
	{
	m_PassageDate = p_PassageDate;
	}

//---------------------------------------------------------------------------

@Column(name = "ordphysicianid")

public String getOrderingPhysicianId() 
	{
	return m_OrderingPhysicianId;
	}

//---------------------------------------------------------------------------

public void setOrderingPhysicianId (String p_OrderingPhysicianId) 
	{
	m_OrderingPhysicianId = p_OrderingPhysicianId;
	}

//---------------------------------------------------------------------------

@Column(name = "ordphysicianname")

public String getOrderingPhysicianName() 
	{
	return m_OrderingPhysicianName;
	}

//---------------------------------------------------------------------------

public void setOrderingPhysicianName (String p_OrderingPhysicianName) 
	{
	m_OrderingPhysicianName = p_OrderingPhysicianName;
	}

//---------------------------------------------------------------------------

@Column(name = "resultsrepdate")

public Date getResultsReportedDate() 
	{
	return m_ResultsReportedDate;
	}

//---------------------------------------------------------------------------

public void setResultsReportedDate (Date p_ResultsReportedDate) 
	{
	m_ResultsReportedDate = p_ResultsReportedDate;
	}

//---------------------------------------------------------------------------

@Column(name = "diagserviceid")

public String getDiagnosticServiceId() 
	{
	return m_DiagnosticServiceId;
	}

//---------------------------------------------------------------------------

public void setDiagnosticServiceId (String p_DiagnosticServiceId) 
	{
	m_DiagnosticServiceId = p_DiagnosticServiceId;
	}

//---------------------------------------------------------------------------

@Column(name = "resultstatus")

public String getResultStatus() 
	{
	return m_ResultStatus;
	}

//---------------------------------------------------------------------------

public void setResultStatus (String p_ResultStatus) 
	{
	m_ResultStatus = p_ResultStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "pattransportmode")

public String getTransportationMode() 
	{
	return m_TransportationMode;
	}

//---------------------------------------------------------------------------

public void setTransportationMode (String p_TransportationMode) 
	{
	m_TransportationMode = p_TransportationMode;
	}

//---------------------------------------------------------------------------

@Column(name = "resultresponsible")

public String getInterpreter() 
	{
	return m_Interpreter;
	}

//---------------------------------------------------------------------------

public void setInterpreter (String p_Interpreter) 
	{
	m_Interpreter = p_Interpreter;
	}

//---------------------------------------------------------------------------

@Column(name = "technicianname")

public String getTechnician() 
	{
	return m_Technician;
	}

//---------------------------------------------------------------------------

public void setTechnician (String p_Technician) 
	{
	m_Technician = p_Technician;
	}

//---------------------------------------------------------------------------

@Column(name = "examinationend")

public Date getExaminationEnd() 
	{
	return m_ExaminationEnd;
	}

//---------------------------------------------------------------------------

public void setExaminationEnd (Date p_ExaminationEnd) 
	{
	m_ExaminationEnd = p_ExaminationEnd;
	}

//---------------------------------------------------------------------------

@Column(name = "reportgendate")

public Date getReportGenerationDate() 
	{
	return m_ReportGenerationDate;
	}

//---------------------------------------------------------------------------

public void setReportGenerationDate (Date p_ReportGenerationDate) 
	{
	m_ReportGenerationDate = p_ReportGenerationDate;
	}

//---------------------------------------------------------------------------

@Column(name = "treatmentaltid")

public String getExaminationAlternateId() 
	{
	return m_ExaminationAlternateId;
	}

//---------------------------------------------------------------------------

public void setExaminationAlternateId (String p_ExaminationAlternateId) 
	{
	m_ExaminationAlternateId = p_ExaminationAlternateId;
	}

//---------------------------------------------------------------------------

//@Lob
//@Basic(fetch=FetchType.LAZY)
@Column(name = "reportdata")

public byte[] getReport() 
	{
	return m_Report;
	}

//---------------------------------------------------------------------------

public void setReport (byte[] p_Report) 
	{
	m_Report = p_Report;
	}

//---------------------------------------------------------------------------

@Column(name = "prodserviceid")

public String getProducerId() 
	{
	return m_ProducerId;
	}

//---------------------------------------------------------------------------

public void setProducerId (String p_ProducerId) 
	{
	m_ProducerId = p_ProducerId;
	}

//---------------------------------------------------------------------------

@Column(name = "obsresultstatus")

public String getExaminationStatus() 
	{
	return m_ExaminationStatus;
	}

//---------------------------------------------------------------------------

public void setExaminationStatus (String p_ExaminationStatus) 
	{
	m_ExaminationStatus = p_ExaminationStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "treatucmcode")

public String getExaminationCode() 
	{
	return m_ExaminationCode;
	}

//---------------------------------------------------------------------------

public void setExaminationCode (String p_ExaminationCode) 
	{
	m_ExaminationCode = p_ExaminationCode;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
