/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_phone", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Phones", 			query = "SELECT OBJECT(o) FROM HL7Phone o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7PhonesByMessageId", 	query = "SELECT OBJECT(o) FROM HL7Phone o WHERE o.messageId = :messageid AND o.quarantined = false"),
	@NamedQuery(name = "getHL7PhonesByPatientId", 	query = "SELECT OBJECT(o) FROM HL7Phone o WHERE o.patientId = :patientid AND o.quarantined = false")
//	@NamedQuery(name = "deleteHL7PhonesByMessageId", query = "DELETE FROM HL7Phone o WHERE o.messageId = :messageid")
	})

public class HL7Phone extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		m_MessageId;
//	private Integer	  	m_PatientId;
	private String	  	m_PatientId;
	private String		m_PrivateNumber;
	private String		m_OfficeNumber;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------


//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "phoneprivate")

public String getPrivateNumber() 
	{
	return m_PrivateNumber;
	}

//---------------------------------------------------------------------------

public void setPrivateNumber (String p_Private) 
	{
	m_PrivateNumber = p_Private;
	}

//---------------------------------------------------------------------------

@Column(name = "phoneoffice")

public String getOfficeNumber() 
	{
	return m_OfficeNumber;
	}

//---------------------------------------------------------------------------

public void setOfficeNumber (String p_OfficeNumber) 
	{
	m_OfficeNumber = p_OfficeNumber;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
