/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_orm", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Orders", 		query = "SELECT OBJECT(o) FROM HL7Order o WHERE o.quarantined = false")
	})

public class HL7Order extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	
	private String	  			m_MessageType;
	private String				m_TriggerEvent;
	private Date				m_MessageDate;
	private String				m_SendingApplication;
	private String				m_SendingFacility;
	private String				m_ControlId;
//	private Integer 			m_PatientId;
	private String 				m_PatientId;
	private String				m_PatientFirstName;
	private String				m_PatientName;
	private String				m_PatientSSN;
	private String				m_PatientClass;
	
	private Integer				m_VisitId;
	private String				m_RadiologistId;
	private String				m_RadiologistName;
	private String				m_OrderingPhysicianId;
	private String				m_OrderingPhysicianName;
	private String	  			m_OrderControlCode;			
	private String				m_PlacerOrderNumber;
	private String				m_FillerOrderNumber;
	private String				m_OrderStatus;
	
	private Integer				m_Quantity;
	private Date				m_ServiceStart;
	private Date				m_ServiceEnd;
	private String				m_PointOfCare;
	private String				m_Room;
	private String				m_Bed;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final Hashtable <String,Integer> m_ORMControlLookup = new Hashtable <String,Integer> (14);
	private static final Hashtable <String,Integer> m_ORMStatusLookup  = new Hashtable <String,Integer> (14);
	
	public static final int	c_Invalid			= -1;
	
	public static final int	c_Unsolicited		= 0;
	public static final int	c_New				= 1;
	public static final int c_StatusChanged 	= 2;
	public static final int c_Replaced		 	= 3;
	
	public static final int	c_Scheduled			= 0;
	public static final int	c_Completed			= 1;
	public static final int c_Canceled		 	= 2;

	private static final String m_ORMControlTags[] = {"XX",	//	c_Unsolicited
													  "NW",	//	c_New
													  "SC",	//	c_StatusChanged
													  "RU"  //	c_Replaced 
													  };

	private static final String m_ORMStatusTags[]  = {"SC",	//	c_Scheduled
													  "CM", //	c_Completed 
		  											  "CA"  //	c_Canceled 
													};

	static {m_ORMControlLookup.put(m_ORMControlTags [c_Unsolicited], 	c_Unsolicited);
			m_ORMControlLookup.put(m_ORMControlTags [c_New], 			c_New);
			m_ORMControlLookup.put(m_ORMControlTags [c_StatusChanged], 	c_StatusChanged);
			m_ORMControlLookup.put(m_ORMControlTags [c_Replaced], 		c_Replaced); }

	static {m_ORMStatusLookup.put(m_ORMStatusTags [c_Scheduled], 		c_Scheduled);
			m_ORMStatusLookup.put(m_ORMStatusTags [c_Completed], 		c_Completed);
		    m_ORMStatusLookup.put(m_ORMStatusTags [c_Canceled], 		c_Canceled); }

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

@Transient	
public int getControlCode ()
	{
	Integer l_Code;
			
	if (this.getTriggerEvent() != null)
		{
		l_Code = m_ORMControlLookup.get(this.getOrderControlCode());
		if (l_Code != null) return l_Code.intValue();
					   else return c_Invalid;		
		}
	else return c_Invalid;
	}

//---------------------------------------------------------------------------

@Transient	
public int getStatusCode ()
	{
	Integer l_Code;
			
	if (this.getTriggerEvent() != null)
		{
		l_Code = m_ORMStatusLookup.get(this.getOrderStatus());
		if (l_Code != null) return l_Code.intValue();
					   else return c_Invalid;		
		}
	else return c_Invalid;
	}

//---------------------------------------------------------------------------

@Transient
public static String getControlTag (int p_Code)
	{
	if ((p_Code >= 0) && (p_Code < m_ORMControlTags.length))
		return m_ORMControlTags [p_Code];
	else return "";
	}

//---------------------------------------------------------------------------

@Transient
public static String getStatusTag (int p_Code)
	{
	if ((p_Code >= 0) && (p_Code < m_ORMStatusTags.length))
		return m_ORMStatusTags [p_Code];
	else return "";
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "messagetype")

public String getMessageType() 
	{
	return m_MessageType;
	}

//---------------------------------------------------------------------------

public void setMessageType (String p_MessageType) 
	{
	m_MessageType = p_MessageType;
	}

//---------------------------------------------------------------------------

@Column(name = "triggerevent")

public String getTriggerEvent() 
	{
	return m_TriggerEvent;
	}

//---------------------------------------------------------------------------

public void setTriggerEvent (String p_TriggerEvent) 
	{
	m_TriggerEvent = p_TriggerEvent;
	}

//---------------------------------------------------------------------------

@Column(name = "messagedate")

public Date getMessageDate() 
	{
	return m_MessageDate;
	}

//---------------------------------------------------------------------------

public void setMessageDate (Date p_MessageDate) 
	{
	m_MessageDate = p_MessageDate;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingapplication")

public String getSendingApplication() 
	{
	return m_SendingApplication;
	}

//---------------------------------------------------------------------------

public void setSendingApplication (String p_SendingApplication) 
	{
	m_SendingApplication = p_SendingApplication;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingfacility")

public String getSendingFacility() 
	{
	return m_SendingFacility;
	}

//---------------------------------------------------------------------------

public void setSendingFacility (String p_SendingFacility) 
	{
	m_SendingFacility = p_SendingFacility;
	}

//---------------------------------------------------------------------------

@Column(name = "controlid")

public String getControlId() 
	{
	return m_ControlId;
	}

//---------------------------------------------------------------------------

public void setControlId (String p_ControlId) 
	{
	m_ControlId = p_ControlId;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------

//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "patgivenname")

public String getPatientFirstName() 
	{
	return m_PatientFirstName;
	}

//---------------------------------------------------------------------------

public void setPatientFirstName (String p_PatientFirstName) 
	{
	m_PatientFirstName = p_PatientFirstName;
	}

//---------------------------------------------------------------------------

@Column(name = "patfamilyname")

public String getPatientName() 
	{
	return m_PatientName;
	}

//---------------------------------------------------------------------------

public void setPatientName (String p_PatientName) 
	{
	m_PatientName = p_PatientName;
	}	

//---------------------------------------------------------------------------

@Column(name = "patssn")

public String getPatientSSN() 
	{
	return m_PatientSSN;
	}

//---------------------------------------------------------------------------

public void setPatientSSN (String p_PatientSSN) 
	{
	m_PatientSSN = p_PatientSSN;
	}	

//---------------------------------------------------------------------------

@Column(name = "patclass")

public String getPatientClass() 
	{
	return m_PatientClass;
	}

//---------------------------------------------------------------------------

public void setPatientClass (String p_PatientClass) 
	{
	m_PatientClass = p_PatientClass;
	}

//---------------------------------------------------------------------------

@Column(name = "radiologistid")

public String getRadiologistId() 
	{
	return m_RadiologistId;
	}

//---------------------------------------------------------------------------

public void setRadiologistId (String p_RadiologistId) 
	{
	m_RadiologistId = p_RadiologistId;
	}

//---------------------------------------------------------------------------

@Column(name = "radiologistname")

public String getRadiologistName() 
	{
	return m_RadiologistName;
	}

//---------------------------------------------------------------------------

public void setRadiologistName (String p_RadiologistName) 
	{
	m_RadiologistName = p_RadiologistName;
	}

//---------------------------------------------------------------------------

@Column(name = "refphysicianid")

public String getOrderingPhysicianId() 
	{
	return m_OrderingPhysicianId;
	}

//---------------------------------------------------------------------------

public void setOrderingPhysicianId (String p_OrderingPhysicianId) 
	{
	m_OrderingPhysicianId = p_OrderingPhysicianId;
	}

//---------------------------------------------------------------------------

@Column(name = "refphysicianname")

public String getOrderingPhysicianName() 
	{
	return m_OrderingPhysicianName;
	}

//---------------------------------------------------------------------------

public void setOrderingPhysicianName (String p_OrderingPhysicianName) 
	{
	m_OrderingPhysicianName = p_OrderingPhysicianName;
	}

//---------------------------------------------------------------------------

@Column(name = "visitid")

public Integer getVisitId() 
	{
	return m_VisitId;
	}

//---------------------------------------------------------------------------

public void setVisitId (Integer p_VisitId) 
	{
	m_VisitId = p_VisitId;
	}

//---------------------------------------------------------------------------

@Column(name = "ordercontrolcode")

public String getOrderControlCode() 
	{
	return m_OrderControlCode;
	}

//---------------------------------------------------------------------------

public void setOrderControlCode (String p_OrderControlCode) 
	{
	m_OrderControlCode = p_OrderControlCode;
	}

//---------------------------------------------------------------------------

@Column(name = "placerordernumber")

public String getPlacerOrderNumber() 
	{
	return m_PlacerOrderNumber;
	}

//---------------------------------------------------------------------------

public void setPlacerOrderNumber (String p_PlacerOrderNumber) 
	{
	m_PlacerOrderNumber = p_PlacerOrderNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "fillerordernumber")

public String getFillerOrderNumber() 
	{
	return m_FillerOrderNumber;
	}

//---------------------------------------------------------------------------

public void setFillerOrderNumber (String p_FillerOrderNumber) 
	{
	m_FillerOrderNumber = p_FillerOrderNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "orderstatus")

public String getOrderStatus() 
	{
	return m_OrderStatus;
	}

//---------------------------------------------------------------------------

public void setOrderStatus (String p_OrderStatus) 
	{
	m_OrderStatus = p_OrderStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "quantity")

public Integer getQuantity() 
	{
	return m_Quantity;
	}

//---------------------------------------------------------------------------

public void setQuantity (Integer p_Quantity) 
	{
	m_Quantity = p_Quantity;
	}

//---------------------------------------------------------------------------

@Column(name = "servicestart")

public Date getServiceStart() 
	{
	return m_ServiceStart;
	}

//---------------------------------------------------------------------------

public void setServiceStart (Date p_ServiceStart) 
	{
	m_ServiceStart = p_ServiceStart;
	}

//---------------------------------------------------------------------------

@Column(name = "serviceend")

public Date getServiceEnd() 
	{
	return m_ServiceEnd;
	}

//---------------------------------------------------------------------------

public void setServiceEnd (Date p_ServiceEnd) 
	{
	m_ServiceEnd = p_ServiceEnd;
	}

//---------------------------------------------------------------------------

@Column(name = "pointofcare")

public String getPointOfCare() 
	{
	return m_PointOfCare;
	}

//---------------------------------------------------------------------------

public void setPointOfCare (String p_PointOfCare) 
	{
	m_PointOfCare = p_PointOfCare;
	}

//---------------------------------------------------------------------------

@Column(name = "room")

public String getRoom() 
	{
	return m_Room;
	}

//---------------------------------------------------------------------------

public void setRoom (String p_Room) 
	{
	m_Room = p_Room;
	}

//---------------------------------------------------------------------------

@Column(name = "bed")

public String getBed() 
	{
	return m_Bed;
	}

//---------------------------------------------------------------------------

public void setBed (String p_Bed) 
	{
	m_Bed = p_Bed;
	}


public String toString() {
	return "ORM ID: " + getMessageId() + 
			" Type: " + getMessageType() + 
			" Trigger: " + getTriggerEvent() + 
			" Patient/RIS ID: " + getPatientId() + 
			" Pat: " + getPatientName() + "," + getPatientFirstName() + " Visid ID: " + getVisitId();
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
