/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_oru", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Observations", query = "SELECT OBJECT(o) FROM HL7Observation o WHERE o.quarantined = false")
	})

public class HL7Observation extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	private String	  			m_MessageType;
	private String				m_TriggerEvent;
	private Date				m_MessageDate;
	private String				m_SendingApplication;
	private String				m_SendingFacility;
	private String				m_ControlId;
//	private Integer 			m_PatientId;
	private String 				m_PatientId;
	private String				m_PatientFirstName;
	private String				m_PatientName;
	private Date				m_PatientBirthdate;
	private String				m_PatientSex;
	private String				m_PatientMaidenName;
	private String				m_PatientMaritalStatus;
	private String				m_PatientAccountNumber;
	private String				m_PatientBirthplace;
	private String				m_PatientClass;
	private Integer				m_VisitId;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final Hashtable <String,Integer> m_ORUEventLookup = new Hashtable <String,Integer> (1);
	
	public static final int	c_Invalid				= -1;
	
	public static final int	c_UnsolicitedReport		= 0;
	
	private static final String m_ORUEventTags[] = { 	"R01" };	//	c_UnscolicitedResult

	static 	{	
			m_ORUEventLookup.put(m_ORUEventTags [c_UnsolicitedReport], 	c_UnsolicitedReport);
			}
	
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

@Transient	
public int getEvent ()
	{
	Integer l_Event;
		
	if (this.getTriggerEvent() != null)
		{
		l_Event = m_ORUEventLookup.get(this.getTriggerEvent());
		if (l_Event != null) return l_Event.intValue();
					   else return c_Invalid;		
		}
	else return c_Invalid;
	}

//---------------------------------------------------------------------------

@Transient
public static String getEventTag (int p_Event)
	{
	if ((p_Event >= 0) && (p_Event < m_ORUEventTags.length))
		return m_ORUEventTags [p_Event];
	else return "";
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "controlid")

public String getControlId() 
	{
	return m_ControlId;
	}

//---------------------------------------------------------------------------

public void setControlId (String p_ControlId) 
	{
	m_ControlId = p_ControlId;
	}

//---------------------------------------------------------------------------

@Column(name = "messagedate")

public Date getMessageDate() 
	{
	return m_MessageDate;
	}

//---------------------------------------------------------------------------

public void setMessageDate (Date p_MessageDate) 
	{
	m_MessageDate = p_MessageDate;
	}

//---------------------------------------------------------------------------

@Column(name = "messagetype")

public String getMessageType() 
	{
	return m_MessageType;
	}

//---------------------------------------------------------------------------

public void setMessageType (String p_MessageType) 
	{
	m_MessageType = p_MessageType;
	}

//---------------------------------------------------------------------------

@Column(name = "patbirthdate")

public Date getPatientBirthdate() 
	{
	return m_PatientBirthdate;
	}

//---------------------------------------------------------------------------

public void setPatientBirthdate (Date p_PatientBirthdate) 
	{
	m_PatientBirthdate = p_PatientBirthdate;
	}

//---------------------------------------------------------------------------

@Column(name = "patbirthplace")

public String getPatientBirthplace() 
	{
	return m_PatientBirthplace;
	}

//---------------------------------------------------------------------------

public void setPatientBirthplace (String p_PatientBirthplace) 
	{
	m_PatientBirthplace = p_PatientBirthplace;
	}

//---------------------------------------------------------------------------

@Column(name = "patclass")

public String getPatientClass() 
	{
	return m_PatientClass;
	}

//---------------------------------------------------------------------------

public void setPatientClass (String p_PatientClass) 
	{
	m_PatientClass = p_PatientClass;
	}

//---------------------------------------------------------------------------

@Column(name = "patgivenname")

public String getPatientFirstName() 
	{
	return m_PatientFirstName;
	}

//---------------------------------------------------------------------------

public void setPatientFirstName (String p_PatientFirstName) 
	{
	m_PatientFirstName = p_PatientFirstName;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------

//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "patmaidenname")

public String getPatientMaidenName() 
	{
	return m_PatientMaidenName;
	}

//---------------------------------------------------------------------------

public void setPatientMaidenName (String p_PatientMaidenName) 
	{
	m_PatientMaidenName = p_PatientMaidenName;
	}

//---------------------------------------------------------------------------

@Column(name = "patmaritalstatus")

public String getPatientMaritalStatus() 
	{
	return m_PatientMaritalStatus;
	}

//---------------------------------------------------------------------------

public void setPatientMaritalStatus (String p_PatientMaritalStatus) 
	{
	m_PatientMaritalStatus = p_PatientMaritalStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "patfamilyname")

public String getPatientName() 
	{
	return m_PatientName;
	}

//---------------------------------------------------------------------------

public void setPatientName (String p_PatientName) 
	{
	m_PatientName = p_PatientName;
	}	

//---------------------------------------------------------------------------

@Column(name = "patsex")

public String getPatientSex() 
	{
	return m_PatientSex;
	}

//---------------------------------------------------------------------------

public void setPatientSex (String p_PatientSex) 
	{
	m_PatientSex = p_PatientSex;
	}

//---------------------------------------------------------------------------

@Column(name = "pataccountnumber")

public String getPatientAccountNumber() 
	{
	return m_PatientAccountNumber;
	}

//---------------------------------------------------------------------------

public void setPatientAccountNumber (String p_PatientAccountNumber) 
	{
	m_PatientAccountNumber = p_PatientAccountNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingapplication")

public String getSendingApplication() 
	{
	return m_SendingApplication;
	}

//---------------------------------------------------------------------------

public void setSendingApplication (String p_SendingApplication) 
	{
	m_SendingApplication = p_SendingApplication;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingfacility")

public String getSendingFacility() 
	{
	return m_SendingFacility;
	}

//---------------------------------------------------------------------------

public void setSendingFacility (String p_SendingFacility) 
	{
	m_SendingFacility = p_SendingFacility;
	}

//---------------------------------------------------------------------------

@Column(name = "triggerevent")

public String getTriggerEvent() 
	{
	return m_TriggerEvent;
	}

//---------------------------------------------------------------------------

public void setTriggerEvent (String p_TriggerEvent) 
	{
	m_TriggerEvent = p_TriggerEvent;
	}

//---------------------------------------------------------------------------

@Column(name = "visitid")

public Integer getVisitId() 
	{
	return m_VisitId;
	}

//---------------------------------------------------------------------------

public void setVisitId (Integer p_VisitId) 
	{
	m_VisitId = p_VisitId;
	}


public String toString() {
	return "ORU ID: " + getMessageId() + 
			" Type: " + getMessageType() + 
			" Trigger: " + getTriggerEvent() + 
			" Patient/RIS ID: " + getPatientId() + 
			" Pat: " + getPatientName() + "," + getPatientFirstName() + " maiden:" + getPatientMaidenName() + " Visid ID: " + getVisitId();
}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
