/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_guarantor", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Guarantors", 			query = "SELECT OBJECT(o) FROM HL7Guarantor o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7GuarantorByMessageId", 	query = "SELECT OBJECT(o) FROM HL7Guarantor o WHERE o.messageId = :messageid AND o.quarantined = false"),
	@NamedQuery(name = "getHL7GuarantorByPatientId", 	query = "SELECT OBJECT(o) FROM HL7Guarantor o WHERE o.patientId = :patientid AND o.quarantined = false")
//	@NamedQuery(name = "deleteHL7GuarantorsByMessageId", query = "DELETE FROM HL7Guarantor o WHERE o.messageId = :messageid")
	})

public class HL7Guarantor extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		m_MessageId;
//	private Integer	  	m_PatientId;
	private String	  	m_PatientId;
	private Integer		m_Identity;
	private String		m_FirstName;
	private String		m_Name;
	private String		m_SSN;
	private Date		m_Birthdate;
	private String		m_Street;
	private String		m_City;
	private String		m_Zip;
	private String		m_Country;
	private String		m_Phone;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	public final static int	c_SamePerson       = 1;
	public final static int c_DifferentPerson  = 5;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Overrides java.lang.Object equals method in order to make sure that
 * equality means same object ID.
 * @return <b>true</b> if the two objects have the same ID, <b>false</b> otherwise
 */
//---------------------------------------------------------------------------	 

//public boolean equals (Object p_OtherHL7Address)	
//	{
//	HL7Address l_OtherHL7Address;
//		
//	if (p_OtherHL7Address == null) return false;
//	
//	l_OtherHL7Address = (HL7Address) p_OtherHL7Address;
//	if ((this.getCountry().equals(l_OtherHL7Address.getCountry())) &&
//		(this.getCity().equals(l_OtherHL7Address.getCity())) &&
//		(this.getZip().equals(l_OtherHL7Address.getZip())) &&
//		(this.getStreet().equals(l_OtherHL7Address.getStreet())))
//		{
//		return true;
//		}
//	else return false;
//	}

//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------

//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "guarantorflag")

public Integer getIdentity() 
	{
	return m_Identity;
	}

//---------------------------------------------------------------------------

public void setIdentity (Integer p_Identity) 
	{
	m_Identity = p_Identity;
	}

//---------------------------------------------------------------------------

@Column(name = "givenname")

public String getFirstName() 
	{
	return m_FirstName;
	}

//---------------------------------------------------------------------------

public void setFirstName (String p_FirstName) 
	{
	m_FirstName = p_FirstName;
	}	

//---------------------------------------------------------------------------

@Column(name = "name")

public String getName() 
	{
	return m_Name;
	}

//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	m_Name = p_Name;
	}	

//---------------------------------------------------------------------------

@Column(name = "ssn")

public String getSSN() 
	{
	return m_SSN;
	}

//---------------------------------------------------------------------------

public void setSSN (String p_SSN) 
	{
	m_SSN = p_SSN;
	}	

//---------------------------------------------------------------------------

@Column(name = "birthdate")

public Date getBirthdate() 
	{
	return m_Birthdate;
	}

//---------------------------------------------------------------------------

public void setBirthdate (Date p_Birthdate) 
	{
	m_Birthdate = p_Birthdate;
	}

//---------------------------------------------------------------------------

@Column(name = "street")

public String getStreet() 
	{
	return m_Street;
	}

//---------------------------------------------------------------------------

public void setStreet (String p_Street) 
	{
	m_Street = p_Street;
	}

//---------------------------------------------------------------------------

@Column(name = "city")

public String getCity() 
	{
	return m_City;
	}

//---------------------------------------------------------------------------

public void setCity (String p_City) 
	{
	m_City = p_City;
	}

//---------------------------------------------------------------------------

@Column(name = "zipcode")

public String getZip() 
	{
	return m_Zip;
	}

//---------------------------------------------------------------------------

public void setZip (String p_Zip) 
	{
	m_Zip = p_Zip;
	}

//---------------------------------------------------------------------------

@Column(name = "country")

public String getCountry() 
	{
	return m_Country;
	}

//---------------------------------------------------------------------------

public void setCountry (String p_Country) 
	{
	m_Country = p_Country;
	}

//---------------------------------------------------------------------------

@Column(name = "phone")

public String getPhone() 
	{
	return m_Phone;
	}

//---------------------------------------------------------------------------

public void setPhone (String p_Phone) 
	{
	m_Phone = p_Phone;
	}


//***************************************************************************
//* End of Class															*
//***************************************************************************
}
