/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@MappedSuperclass
public class HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer	m_Id;
	private Boolean m_Quarantined;
	
//***************************************************************************
//* Constants                                                               *
//***************************************************************************
	
	public static final int c_MaxBatchSize	= 100;
	
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * Overrides java.lang.Object equals method in order to make sure that
 * equality means same object ID.
 * @return <b>true</b> if the two objects have the same ID, <b>false</b> otherwise
 */
//---------------------------------------------------------------------------	 

public boolean equals (Object p_OtherHL7Bean)	
	{
	HL7Bean l_OtherHL7Bean;
		
	if (p_OtherHL7Bean == null) return false;
	
	if (! (p_OtherHL7Bean instanceof HL7Bean)) return false;
	
	l_OtherHL7Bean = (HL7Bean) p_OtherHL7Bean;
	if ((this.getId() != null) && (l_OtherHL7Bean.getId() != null))
		 return l_OtherHL7Bean.getId().equals(this.getId());
	else return false;
	}

//---------------------------------------------------------------------------
/**
 * Overrides java.lang.Object hashCode method. Algorithm taken from 
 * Effective Java Book, Chapter 3. Overriding hashCode method is a MUST
 * when you override equals method.
 */
//---------------------------------------------------------------------------

public int hashCode ()
	{
	int	l_Code = 17;
	
	if (m_Id != null)	
		{
		l_Code = 37*l_Code + m_Id.intValue();
		}		
	else	
		{
		l_Code = super.hashCode();
		}
		
	return l_Code;
	}

//---------------------------------------------------------------------------
/**
 * Get the object ID.
 * @return The object ID.
 */
//---------------------------------------------------------------------------
	
@Id
@Column(name = "oid")

public Integer getId() 
	{
	return this.m_Id;
	}

//---------------------------------------------------------------------------
/**
 * Sets the object ID
 * @param p_ID
 */
//---------------------------------------------------------------------------

public void setId (Integer p_Id) 
	{
	this.m_Id = p_Id;
	}


//---------------------------------------------------------------------------
/**
 * Returns the state of the quarantined flag.
 * @return <code>TRUE</code> if HL7Bean has been put into quarantine,
 * <code>FALSE</code> otherwise.
 */
//---------------------------------------------------------------------------
	
@Column(name = "quarantined")

public Boolean getQuarantined() 
	{
	return this.m_Quarantined;
	}

//---------------------------------------------------------------------------
/**
 * Sets the state of the quarantined flag.
 * @param p_Quarantined specifies whether or not to put this bean into
 * quarantine. <code>TRUE</code> puts it into quarantine,
 * <code>FALSE</code> removes it from quarantine.
 */
//---------------------------------------------------------------------------

public void setQuarantined (Boolean p_Quarantined) 
	{
	this.m_Quarantined = p_Quarantined;
	}

//---------------------------------------------------------------------------
/**
 * Use this method to check whether the entity is already persisted 
 * or not.
 * 
 * @return
 */
//---------------------------------------------------------------------------

@Transient
public Boolean isPersistent() 
	{
	if (this.getId() != null) return true;
							return false;	
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
